/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http.util;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.security.cookie.HttpOnlyCookies;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdHttpTokenHelperImpl
implements CrowdHttpTokenHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrowdHttpTokenHelperImpl.class);
    private final CrowdHttpValidationFactorExtractor validationFactorExtractor;

    private CrowdHttpTokenHelperImpl(CrowdHttpValidationFactorExtractor validationFactorExtractor) {
        this.validationFactorExtractor = validationFactorExtractor;
    }

    @Override
    public String getCrowdToken(HttpServletRequest request, String tokenName) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)tokenName);
        LOGGER.debug("Checking for a SSO token that will need to be verified by Crowd.");
        String token = (String)request.getAttribute("crowd.token_key");
        if (token == null) {
            LOGGER.debug("No request attribute token could be found, now checking the browser submitted cookies.");
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                Iterable tokenCookies;
                if (LOGGER.isDebugEnabled()) {
                    for (Cookie cookie : cookies) {
                        LOGGER.debug("Cookie name/value: " + cookie.getName() + " / " + cookie.getValue());
                    }
                }
                if (!Iterables.isEmpty((Iterable)(tokenCookies = Iterables.filter(Arrays.asList(cookies), CrowdHttpTokenHelperImpl.nonEmptyCookiesCalled(tokenName))))) {
                    token = ((Cookie)tokenCookies.iterator().next()).getValue();
                    LOGGER.debug("Accepting the SSO cookie value: {}", (Object)token);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            if (token == null) {
                LOGGER.debug("Unable to find a valid Crowd token.");
            } else {
                LOGGER.debug("Existing token value yet to be verified by Crowd: " + token);
            }
        }
        return token;
    }

    @Override
    public void removeCrowdToken(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, CookieConfiguration cookieConfig) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)clientProperties);
        if (response != null) {
            Validate.notNull((Object)cookieConfig);
        }
        HttpSession session = request.getSession();
        session.removeAttribute(clientProperties.getSessionTokenKey());
        request.removeAttribute("crowd.token_key");
        if (response != null) {
            Cookie tokenCookie = this.buildCookie(null, clientProperties.getCookieTokenKey(cookieConfig.getName()), cookieConfig, clientProperties);
            tokenCookie.setMaxAge(0);
            HttpOnlyCookies.addHttpOnlyCookie((HttpServletResponse)response, (Cookie)tokenCookie);
        }
    }

    @Override
    public void setCrowdToken(HttpServletRequest request, HttpServletResponse response, String token, ClientProperties clientProperties, CookieConfiguration cookieConfig) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)token);
        Validate.notNull((Object)clientProperties);
        if (response != null) {
            Validate.notNull((Object)cookieConfig);
        }
        HttpSession session = request.getSession();
        session.setAttribute(clientProperties.getSessionLastValidation(), (Object)new Date());
        request.setAttribute("crowd.token_key", (Object)token);
        if (response != null && request.getAttribute("com.atlassian.crowd.integration.http.HttpAuthenticator.REQUEST_SSO_COOKIE_COMMITTED") == null) {
            Cookie tokenCookie = this.buildCookie(token, clientProperties.getCookieTokenKey(cookieConfig.getName()), cookieConfig, clientProperties);
            HttpOnlyCookies.addHttpOnlyCookie((HttpServletResponse)response, (Cookie)tokenCookie);
            request.setAttribute("com.atlassian.crowd.integration.http.HttpAuthenticator.REQUEST_SSO_COOKIE_COMMITTED", (Object)Boolean.TRUE);
        }
    }

    @Override
    public UserAuthenticationContext getUserAuthenticationContext(HttpServletRequest request, String username, String password, ClientProperties clientProperties) {
        PasswordCredential credential = new PasswordCredential(password);
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext();
        userAuthenticationContext.setApplication(clientProperties.getApplicationName());
        userAuthenticationContext.setCredential(credential);
        userAuthenticationContext.setName(username);
        List<ValidationFactor> validationFactors = this.validationFactorExtractor.getValidationFactors(request);
        userAuthenticationContext.setValidationFactors(validationFactors.toArray(new ValidationFactor[0]));
        return userAuthenticationContext;
    }

    @Override
    public CrowdHttpValidationFactorExtractor getValidationFactorExtractor() {
        return this.validationFactorExtractor;
    }

    private Cookie buildCookie(String token, String tokenCookieKey, CookieConfiguration cookieConfig, ClientProperties clientProperties) {
        String domain = !StringUtils.isBlank((String)clientProperties.getSSOCookieDomainName()) ? clientProperties.getSSOCookieDomainName() : cookieConfig.getDomain();
        boolean isSecure = cookieConfig.isSecure();
        Cookie tokenCookie = new Cookie(tokenCookieKey, token);
        tokenCookie.setPath("/");
        if (domain != null && StringUtils.isNotBlank((String)domain) && !"localhost".equals(domain)) {
            tokenCookie.setDomain(domain);
        }
        tokenCookie.setSecure(isSecure);
        return tokenCookie;
    }

    public static CrowdHttpTokenHelper getInstance(CrowdHttpValidationFactorExtractor validationFactorExtractor) {
        return new CrowdHttpTokenHelperImpl(validationFactorExtractor);
    }

    private static Predicate<Cookie> nonEmptyCookiesCalled(final String tokenName) {
        return new Predicate<Cookie>(){

            public boolean apply(Cookie cookie) {
                return tokenName.equals(cookie.getName()) && cookie.getValue() != null;
            }
        };
    }
}

