/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.event;

import com.atlassian.crowd.model.event.Operation;
import com.atlassian.crowd.model.event.OperationEvent;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class AliasEvent
implements OperationEvent {
    private final Operation operation;
    private final long applicationId;
    private final String username;
    @Nullable
    private final String newAlias;

    private AliasEvent(Operation operation, long applicationId, String username, @Nullable String newAlias) {
        this.operation = Objects.requireNonNull(operation);
        this.applicationId = applicationId;
        this.username = Objects.requireNonNull(username);
        this.newAlias = newAlias;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getNewAlias() {
        return this.newAlias;
    }

    @Override
    public Long getDirectoryId() {
        return null;
    }

    public static AliasEvent created(long applicationId, String user, String newAlias) {
        return new AliasEvent(Operation.CREATED, applicationId, user, newAlias);
    }

    public static AliasEvent updated(long applicationId, String user, String newAlias) {
        return new AliasEvent(Operation.UPDATED, applicationId, user, newAlias);
    }

    public static AliasEvent deleted(String user, long applicationId) {
        return new AliasEvent(Operation.DELETED, applicationId, user, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasEvent that = (AliasEvent)o;
        return this.applicationId == that.applicationId && this.operation == that.operation && Objects.equals(this.username, that.username) && Objects.equals(this.newAlias, that.newAlias);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.applicationId, this.username, this.newAlias});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + String.join((CharSequence)", ", "operation=" + String.valueOf((Object)this.operation), "applicationId=" + this.applicationId, "username='" + this.username + "'", "newAlias='" + this.newAlias + "'") + "}";
    }
}

