/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyUtils {
    private static final Logger logger = Logger.getLogger(PropertyUtils.class);

    public Properties getProperties(String propertyResourceLocation) {
        Properties properties = null;
        if (propertyResourceLocation != null) {
            try {
                URL url = new URL(propertyResourceLocation);
                properties = this.getPropertiesFromStream(url.openStream());
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getPropertiesFromStream(InputStream is) {
        if (is == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            logger.error((Object)"Error loading properties from stream.", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error((Object)("Failed to close the stream: " + e.getMessage()), (Throwable)e);
            }
        }
        return props;
    }

    public boolean removeProperty(String propertyResourceLocation, String key) {
        boolean success = false;
        Properties properties = this.getProperties(propertyResourceLocation);
        Object currentValue = properties.remove(key);
        logger.info((Object)("Updating properties resource: " + propertyResourceLocation + " removing property with key: " + key));
        if (currentValue != null) {
            success = true;
        }
        this.storeProperties(propertyResourceLocation, properties);
        return success;
    }

    public void updateProperty(String propertyResourceLocation, String key, String value) {
        Properties properties = this.getProperties(propertyResourceLocation);
        if (properties != null) {
            properties.setProperty(key, value);
            logger.info((Object)("Updating properties resource: " + propertyResourceLocation + " adding property: " + key + "|" + value));
            this.storeProperties(propertyResourceLocation, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeProperties(String propertyResourceLocation, Properties properties) {
        OutputStream ostream = null;
        try {
            String crowdFile = URLDecoder.decode(new URL(propertyResourceLocation).getFile(), "UTF-8");
            ostream = new FileOutputStream(crowdFile);
            properties.store(ostream, null);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

