/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.soap.client;

import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.service.soap.client.ClientProperties;
import com.atlassian.crowd.integration.service.soap.client.ResourceLocator;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClientPropertiesImpl
implements ClientProperties {
    private final Logger logger = Logger.getLogger(this.getClass());
    private String applicationName = null;
    private String applicationPassword = null;
    private String applicationAuthenticationURL = null;
    private String securityServerURL = null;
    private String cookieTokenKey = null;
    private String sessionIsAuthenticated = null;
    private String sessionTokenKey = null;
    private String sessionLastValidation = null;
    private long sessionValidationInterval = 0L;
    private String baseURL = null;
    private String httpProxyPort = null;
    private String httpProxyHost = null;
    private String httpProxyUsername = null;
    private String httpProxyPassword = null;
    private String httpMaxConnections = null;
    private String httpTimeout = null;
    private ApplicationAuthenticationContext applicationAuthenticationContext = null;

    public ClientPropertiesImpl(ResourceLocator resourceLocator) {
        Properties properties = resourceLocator.getProperties();
        this.updateProperties(properties);
    }

    public ClientPropertiesImpl(Properties properties) {
        this.updateProperties(properties);
    }

    public void updateProperties(Properties properties) {
        this.applicationName = this.loadAndLogPropertyString(properties, "application.name");
        this.applicationPassword = this.loadPropertyString(properties, "application.password");
        this.applicationAuthenticationURL = this.loadAndLogPropertyString(properties, "application.login.url");
        this.setSecurityServerURL(this.loadAndLogPropertyString(properties, "crowd.server.url"));
        this.cookieTokenKey = this.loadPropertyString(properties, "cookie.tokenkey");
        if (this.cookieTokenKey == null) {
            this.cookieTokenKey = "crowd.token_key";
        }
        this.sessionIsAuthenticated = this.loadAndLogPropertyString(properties, "session.isauthenticated");
        this.sessionTokenKey = this.loadAndLogPropertyString(properties, "session.tokenkey");
        this.sessionLastValidation = this.loadAndLogPropertyString(properties, "session.lastvalidation");
        this.sessionValidationInterval = this.loadPropertyLong(properties, "session.validationinterval", true);
        this.httpProxyHost = this.loadPropertyString(properties, "http.proxy.host");
        this.httpProxyPort = this.loadPropertyString(properties, "http.proxy.port");
        this.httpProxyUsername = this.loadPropertyString(properties, "http.proxy.username");
        this.httpProxyPassword = this.loadPropertyString(properties, "http.proxy.password");
        this.httpMaxConnections = this.loadPropertyString(properties, "http.max.connections");
        this.httpTimeout = this.loadPropertyString(properties, "http.timeout");
        PasswordCredential credentials = new PasswordCredential(this.applicationPassword);
        this.applicationAuthenticationContext = new ApplicationAuthenticationContext();
        this.applicationAuthenticationContext.setName(this.applicationName);
        this.applicationAuthenticationContext.setCredential(credentials);
        this.baseURL = this.generateBaseURL();
    }

    private long loadPropertyLong(Properties properties, String propertyName, boolean logProperty) {
        long propertyValue = 0L;
        String propertyValueAsString = logProperty ? this.loadAndLogPropertyString(properties, propertyName) : this.loadPropertyString(properties, propertyName);
        if (propertyValueAsString != null) {
            propertyValue = Long.parseLong(propertyValueAsString);
        }
        return propertyValue;
    }

    private String loadPropertyString(Properties properties, String propertyName) {
        String propertyValue = null;
        if (properties != null && properties.containsKey(propertyName)) {
            propertyValue = StringUtils.trimToNull((String)properties.getProperty(propertyName));
        }
        return propertyValue;
    }

    private String loadAndLogPropertyString(Properties properties, String propertyName) {
        String propertyValue = this.loadPropertyString(properties, propertyName);
        if (propertyValue != null) {
            this.logger.info((Object)("Loading property: '" + propertyName + "' : '" + propertyValue + "'"));
        } else {
            this.logger.info((Object)("Failed to find value for property: " + propertyName));
        }
        return propertyValue;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationPassword() {
        return this.applicationPassword;
    }

    public String getApplicationAuthenticationURL() {
        return this.applicationAuthenticationURL;
    }

    public String getSecurityServerURL() {
        return this.securityServerURL;
    }

    private void setSecurityServerURL(String url) {
        this.securityServerURL = (url = StringUtils.removeEnd((String)url, (String)"/")) != null ? (url.endsWith("SecurityServer") ? url : (url.endsWith("services") ? url + "/" + "SecurityServer" : url + "/" + "services" + "/" + "SecurityServer")) : url;
    }

    public String getCookieTokenKey() {
        return this.cookieTokenKey;
    }

    public String getSessionIsAuthenticated() {
        return this.sessionIsAuthenticated;
    }

    public String getSessionTokenKey() {
        return this.sessionTokenKey;
    }

    public String getSessionLastValidation() {
        return this.sessionLastValidation;
    }

    public long getSessionValidationInterval() {
        return this.sessionValidationInterval;
    }

    public ApplicationAuthenticationContext getApplicationAuthenticationContext() {
        return this.applicationAuthenticationContext;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public String getHttpMaxConnections() {
        return this.httpMaxConnections;
    }

    public String getHttpTimeout() {
        return this.httpTimeout;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    private String generateBaseURL() {
        String url = this.getSecurityServerURL();
        int firstSlash = StringUtils.lastIndexOf((String)url, (String)"/services");
        if (firstSlash != -1) {
            url = url.substring(0, firstSlash);
        }
        return url;
    }
}

