/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.cache.BasicCache;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.atlassian.crowd.integration.util.Assert;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingUserManager
implements UserManager {
    private static final String DEFAULT_BLANK = "-";
    private final Server server;
    private final BasicCache basicCache;

    public CachingUserManager(SecurityServerClient securityServerClient, BasicCache basicCache) {
        this.basicCache = basicCache;
        this.server = new Server(securityServerClient);
    }

    @Override
    public SOAPPrincipal getUser(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        Assert.notNull(userName);
        SOAPPrincipal user = this.basicCache.getUser(userName);
        if (user == null) {
            user = this.server.getUser(userName);
            this.basicCache.addOrReplaceUser(user);
        }
        return user;
    }

    @Override
    public SOAPPrincipal getUserFromToken(String token) throws RemoteException, InvalidAuthorizationTokenException, InvalidTokenException, ObjectNotFoundException {
        SOAPPrincipal user = this.server.getUserFromToken(token);
        this.basicCache.addOrReplaceUser(user);
        return user;
    }

    @Override
    public List searchUsers(SearchRestriction[] restrictions) throws RemoteException, InvalidAuthorizationTokenException {
        return this.server.searchUsers(restrictions);
    }

    @Override
    public SOAPPrincipal addUser(SOAPPrincipal user, PasswordCredential credential) throws RemoteException, ApplicationPermissionException, InvalidCredentialException, InvalidUserException, InvalidAuthorizationTokenException {
        Assert.notNull(user);
        Assert.notNull(user.getName());
        ArrayList<SOAPAttribute> attributesToAdd = new ArrayList<SOAPAttribute>();
        this.updateNullToDefaultValue(user, "mail", DEFAULT_BLANK, attributesToAdd);
        this.updateNullToDefaultValue(user, "givenName", DEFAULT_BLANK, attributesToAdd);
        this.updateNullToDefaultValue(user, "sn", DEFAULT_BLANK, attributesToAdd);
        this.updateNullToDefaultValue(user, "displayName", DEFAULT_BLANK, attributesToAdd);
        if (!attributesToAdd.isEmpty()) {
            if (user.getAttributes() != null) {
                attributesToAdd.addAll(Arrays.asList(user.getAttributes()));
            }
            user.setAttributes(attributesToAdd.toArray(new SOAPAttribute[attributesToAdd.size()]));
        }
        if (credential == null || credential.getCredential() == null) {
            credential = new PasswordCredential(DEFAULT_BLANK);
        }
        user = this.server.addUser(user, credential);
        this.basicCache.addOrReplaceUser(user);
        this.basicCache.addToAllUsers(user.getName());
        return user;
    }

    private void updateNullToDefaultValue(SOAPPrincipal user, String attributeName, String defaultValue, List<SOAPAttribute> attributesToAdd) {
        SOAPAttribute attribute = user.getAttribute(attributeName);
        if (attribute == null) {
            attribute = new SOAPAttribute(attributeName, defaultValue);
            attributesToAdd.add(attribute);
        } else if (attribute.getValues() == null || attribute.getValues().length == 0 || attribute.getValues()[0] != null) {
            String[] value = new String[]{defaultValue};
            attribute.setValues(value);
        }
    }

    @Override
    public void updateUser(SOAPPrincipal user) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
        Assert.notNull(user);
        this.server.updateUser(user);
        this.basicCache.addOrReplaceUser(user);
    }

    @Override
    public void updatePassword(String userName, PasswordCredential credential) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException {
        Assert.notNull(userName);
        this.server.updatePassword(userName, credential);
    }

    @Override
    public void removeUser(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Assert.notNull(userName);
        this.server.removeUser(userName);
        this.basicCache.removeAllMemberships(userName);
        this.basicCache.removeUser(userName);
        this.basicCache.removeFromAllUsers(userName);
    }

    @Override
    public List getAllUserNames() throws RemoteException, InvalidAuthorizationTokenException {
        return this.getAllUserNamesFromCacheOrServer();
    }

    @Override
    public boolean isUser(String userName) throws RemoteException, InvalidAuthorizationTokenException {
        Assert.notNull(userName);
        this.getAllUserNamesFromCacheOrServer();
        return this.basicCache.getUser(userName) != null;
    }

    private List getAllUserNamesFromCacheOrServer() throws RemoteException, InvalidAuthorizationTokenException {
        List userNames = this.basicCache.getAllUserNames();
        if (userNames == null) {
            this.loadAllUsers();
            userNames = this.basicCache.getAllUserNames();
        }
        return userNames;
    }

    private void loadAllUsers() throws RemoteException, InvalidAuthorizationTokenException {
        List users = this.searchUsers(new SearchRestriction[0]);
        if (users != null) {
            ArrayList<String> userNames = new ArrayList<String>(users.size());
            for (SOAPPrincipal user : users) {
                userNames.add(user.getName());
                this.basicCache.addOrReplaceUser(user);
            }
            this.basicCache.addOrReplaceAllUserNames(userNames);
        }
    }

    private static class Server {
        private final SecurityServerClient securityServerClient;

        private Server(SecurityServerClient securityServerClient) {
            this.securityServerClient = securityServerClient;
        }

        protected SOAPPrincipal addUser(SOAPPrincipal user, PasswordCredential credential) throws RemoteException, ApplicationPermissionException, InvalidCredentialException, InvalidUserException, InvalidAuthorizationTokenException {
            return this.securityServerClient.addPrincipal(user, credential);
        }

        protected void updateUser(SOAPPrincipal user) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
            SOAPAttribute[] attributes = user.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.length; ++i) {
                    this.securityServerClient.updatePrincipalAttribute(user.getName(), attributes[i]);
                }
            }
        }

        protected void updatePassword(String userName, PasswordCredential credential) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException {
            this.securityServerClient.updatePrincipalCredential(userName, credential);
        }

        protected void removeUser(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
            this.securityServerClient.removePrincipal(userName);
        }

        protected SOAPPrincipal getUser(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
            return this.securityServerClient.findPrincipalByName(userName);
        }

        protected SOAPPrincipal getUserFromToken(String token) throws RemoteException, InvalidAuthorizationTokenException, InvalidTokenException, ObjectNotFoundException {
            return this.securityServerClient.findPrincipalByToken(token);
        }

        protected List getAllUserNames() throws RemoteException, InvalidAuthorizationTokenException {
            String[] userNames = this.securityServerClient.findAllPrincipalNames();
            if (userNames != null) {
                return new ArrayList<String>(Arrays.asList(userNames));
            }
            return null;
        }

        public List searchUsers(SearchRestriction[] restrictions) throws RemoteException, InvalidAuthorizationTokenException {
            SOAPPrincipal[] users = this.securityServerClient.searchPrincipals(restrictions);
            if (users != null) {
                return Arrays.asList(users);
            }
            return null;
        }
    }
}

