/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.GroupManager;
import com.atlassian.crowd.integration.service.cache.CacheFactory;
import com.atlassian.crowd.integration.service.cache.CachingGroupMembershipManager;
import com.atlassian.crowd.integration.service.cache.GroupCache;
import com.atlassian.crowd.integration.service.cache.NestingHelper;
import com.atlassian.crowd.integration.service.cache.Null;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CachingGroupManager
implements GroupManager {
    private Server server;
    private CachingGroupMembershipManager membershipManager;

    public CachingGroupManager() {
    }

    public CachingGroupManager(SecurityServerClient ssc) {
        this.setSecurityServerClient(ssc);
    }

    private GroupCache getCache() {
        return CacheFactory.getGroupInstance();
    }

    public boolean isGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException {
        Null.not(groupName);
        try {
            return this.getGroup(groupName) != null;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return false;
        }
    }

    public SOAPGroup getGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        Null.not(groupName);
        SOAPGroup group = this.getCache().getGroup(groupName);
        if (group == null) {
            group = this.server.getGroup(groupName);
            this.membershipManager.cacheAndStripMembers(group);
            this.getCache().addOrReplaceGroup(group);
        }
        return group;
    }

    public SOAPGroup addGroup(SOAPGroup group) throws RemoteException, InvalidGroupException, InvalidAuthorizationTokenException, ApplicationPermissionException {
        Null.not(group);
        Null.not(group.getName());
        group = this.server.addGroup(group);
        this.getCache().addOrReplaceGroup(group);
        this.addToAllGroupNames(group.getName());
        return group;
    }

    public List searchGroups(SearchRestriction[] restrictions) throws RemoteException, InvalidAuthorizationTokenException {
        return this.server.searchGroups(restrictions);
    }

    public void updateGroup(SOAPGroup group) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
        Null.not(group);
        this.server.updateGroup(group);
        this.getCache().addOrReplaceGroup(group);
    }

    public void removeGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Null.not(groupName);
        this.server.removeGroup(groupName);
        this.getCache().removeGroup(groupName);
        this.membershipManager.removeCachedGroup(groupName);
        this.removeFromAllGroupNames(groupName);
    }

    public List getAllGroupNames() throws RemoteException, InvalidAuthorizationTokenException {
        List groupNames = this.getCache().getAllGroupNames();
        if (groupNames == null) {
            groupNames = this.server.getAllGroupNames();
            this.getCache().addOrReplaceAllGroupNames(groupNames);
        }
        return groupNames;
    }

    private void addToAllGroupNames(String groupName) {
        Null.not(groupName);
        List allGroups = this.getCache().getAllGroupNames();
        if (allGroups != null && !allGroups.contains(groupName)) {
            allGroups.add(groupName);
            Collections.sort(allGroups);
        }
    }

    private void removeFromAllGroupNames(String groupName) {
        Null.not(groupName);
        List allGroups = this.getCache().getAllGroupNames();
        if (allGroups != null) {
            allGroups.remove(groupName);
        }
    }

    public void setSecurityServerClient(SecurityServerClient ssc) {
        this.server = new Server(ssc);
    }

    public void setCachingGroupMembershipManager(CachingGroupMembershipManager membershipManager) {
        this.membershipManager = membershipManager;
    }

    class Server {
        SecurityServerClient ssc;

        public Server(SecurityServerClient ssc) {
            this.ssc = ssc;
        }

        private SecurityServerClient getSSC() {
            return this.ssc;
        }

        public SOAPGroup getGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
            return this.getSSC().findGroupByName(groupName);
        }

        public List searchGroups(SearchRestriction[] restrictions) throws RemoteException, InvalidAuthorizationTokenException {
            SOAPGroup[] groups = this.getSSC().searchGroups(restrictions);
            return Arrays.asList(groups);
        }

        public SOAPGroup addGroup(SOAPGroup group) throws RemoteException, ApplicationPermissionException, InvalidAuthorizationTokenException, InvalidGroupException {
            return this.getSSC().addGroup(group);
        }

        public void updateGroup(SOAPGroup group) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
            this.getSSC().updateGroup(group.getName(), group.getDescription(), group.isActive());
        }

        public void removeGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
            this.getSSC().removeGroup(groupName);
        }

        public List getAllGroupNames() throws RemoteException, InvalidAuthorizationTokenException {
            SOAPNestableGroup[] allGroups = this.getSSC().findAllGroupRelationships();
            if (allGroups == null) {
                return null;
            }
            return NestingHelper.getAllGroupNames(allGroups, CachingGroupManager.this.getCache());
        }
    }
}

