/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentDraftService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentDraftService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.sun.jersey.api.client.WebResource;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;

public class RemoteContentDraftServiceImpl
extends AbstractRemoteService<ContentDraftService>
implements RemoteContentDraftService {
    public RemoteContentDraftServiceImpl(AuthenticatedWebResourceProvider provider, ExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public CompletionStage<Content> publishNewDraftCompletionStage(Content content, Expansion ... expansions) {
        WebResource resource = this.newDraftContentWebResource();
        resource = this.addExpansions(resource, expansions);
        return this.postCompletionStage(resource, Content.class, content);
    }

    @Override
    public CompletionStage<Content> publishEditDraftCompletionStage(Content content, ContentDraftService.ConflictPolicy conflictPolicy) {
        WebResource resource = this.newDraftContentWebResourceWithId(content.getId());
        if (conflictPolicy != null) {
            resource = resource.queryParam("conflictPolicy", conflictPolicy.getValue());
        }
        return this.putCompletionStage(resource, Content.class, content);
    }

    @Override
    public CompletionStage<Void> deleteDraftCompletionStage(ContentId contentId) {
        WebResource resource = this.newDraftContentWebResourceWithId(contentId);
        return this.deleteCompletionStage(resource);
    }

    private WebResource newDraftContentWebResource() {
        return this.newRestWebResource().path("content").queryParam("status", ContentStatus.DRAFT.serialise());
    }

    private WebResource newDraftContentWebResourceWithId(ContentId contentId) {
        return this.newDraftContentWebResource().path(contentId.serialise());
    }
}

