/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ContentLabelService;
import com.atlassian.confluence.rest.client.AbstractRemoteContentLabelService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.StringKeyStringValueIgnoreCaseMultivaluedMap;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;

public class RemoteContentLabelServiceImpl
extends AbstractRemoteContentLabelService {
    public RemoteContentLabelServiceImpl(AuthenticatedWebResourceProvider provider, ExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public CompletionStage<PageResponse<Label>> getLabelsCompletionStage(ContentId contentId, Collection<Label.Prefix> prefixes, PageRequest request) {
        List prefixStrings = prefixes.stream().map(Enum::name).collect(Collectors.toList());
        WebResource resource = this.newRestWebResource().path("content").path(contentId.serialise()).path("label");
        StringKeyStringValueIgnoreCaseMultivaluedMap params = new StringKeyStringValueIgnoreCaseMultivaluedMap();
        params.put((Object)"prefix", prefixStrings);
        resource = resource.queryParams((MultivaluedMap)params);
        resource = this.addPageRequestParams(resource, request);
        return this.getCompletionStagePageResponseList(resource, Label.class);
    }

    @Override
    public ContentLabelService.Validator validator() {
        throw new UnsupportedOperationException("Remote validation is not currently supported.");
    }
}

