/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.graphql;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.model.BaseApiEnum;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.GraphQLQueryExpansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.rest.client.AbstractRemoteContentService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.graphql.GraphQLQueryResponse;
import com.atlassian.confluence.rest.client.graphql.GraphQLUtils;
import com.atlassian.confluence.rest.serialization.graphql.GraphQLPageResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

@Internal
public class GraphQLRemoteContentServiceImpl
extends AbstractRemoteContentService {
    private final String defaultGraphQLQuery;

    public GraphQLRemoteContentServiceImpl(AuthenticatedWebResourceProvider provider, ExecutorService executor, String defaultGraphQLQuery) {
        super(provider, executor);
        this.defaultGraphQLQuery = Objects.requireNonNull(defaultGraphQLQuery);
    }

    @Override
    public RemoteContentService.RemoteContentFinder find(Expansion ... expansions) {
        return new RemoteContentFinderImpl((AbstractRemoteContentService)this, expansions);
    }

    protected class RemoteContentFinderImpl
    extends AbstractRemoteContentService.AbstractRemoteContentFinder {
        private String graphqlQuery;

        RemoteContentFinderImpl(AbstractRemoteContentService otherService, Expansion ... expansions) {
            super(otherService, expansions);
            this.graphqlQuery = GraphQLRemoteContentServiceImpl.this.defaultGraphQLQuery;
            if (expansions.length != 0) {
                if (expansions.length > 1 || !(expansions[0] instanceof GraphQLQueryExpansion)) {
                    throw new IllegalArgumentException("Expected a single expansion of type '" + GraphQLQueryExpansion.class.getSimpleName() + "'");
                }
                this.graphqlQuery = ((GraphQLQueryExpansion)expansions[0]).getQuery();
            }
        }

        @Override
        public CompletionStage<PageResponse<Content>> fetchManyCompletionStage(ContentType type, PageRequest request) {
            String requestString = this.buildFetchManyRequestString(type, request);
            CompletionStage<GraphQLQueryContentResponse> responsePromise = this.postCompletionStage(this.newGraphWebResource(), GraphQLQueryContentResponse.class, requestString);
            return responsePromise.thenApplyAsync(response -> {
                response.throwFirstErrorIfExists();
                return (PageResponse)((Map)response.getData()).get("content");
            }, this.getExecutor());
        }

        private String buildFetchManyRequestString(ContentType type, PageRequest request) {
            HashMap<String, Object> queryArguments = new HashMap<String, Object>();
            if (request != null) {
                queryArguments.put("offset", request.getStart());
                queryArguments.put("first", request.getLimit());
            }
            if (this.title != null) {
                queryArguments.put("title", this.title);
            }
            if (this.spaceKey != null) {
                queryArguments.put("spaceKey", this.spaceKey);
            }
            this.handleStatuses(queryArguments);
            queryArguments.put("type", type.getType());
            if (this.createdDate != null) {
                queryArguments.put("postingDay", this.createdDate.toString());
            }
            return GraphQLUtils.buildRequestString("content", this.graphqlQuery, queryArguments);
        }

        @Override
        protected CompletionStage<Optional<Content>> fetchByIdCompletionStage() {
            String requestString = this.buildFetchByIdRequestString();
            CompletionStage<GraphQLQueryContentResponse> responsePromise = this.postCompletionStage(this.newGraphWebResource(), GraphQLQueryContentResponse.class, requestString);
            return responsePromise.thenApplyAsync(response -> {
                try {
                    response.throwFirstErrorIfExists();
                }
                catch (NotFoundException ex) {
                    return Optional.empty();
                }
                PageResponse pageResponse = (PageResponse)((Map)response.getData()).get("content");
                return pageResponse.size() != 0 ? Optional.of((Content)pageResponse.getResults().get(0)) : Optional.empty();
            }, this.getExecutor());
        }

        private String buildFetchByIdRequestString() {
            HashMap<String, Object> queryArguments = new HashMap<String, Object>();
            queryArguments.put("id", this.contentId.serialise());
            if (this.version > 0) {
                queryArguments.put("version", this.version);
            }
            this.handleStatuses(queryArguments);
            return GraphQLUtils.buildRequestString("content", this.graphqlQuery, queryArguments);
        }

        private void handleStatuses(Map<String, Object> arguments) {
            boolean onlyContainsCurrent;
            boolean bl = onlyContainsCurrent = this.getStatuses().contains(ContentStatus.CURRENT) && this.getStatuses().size() == 1;
            if (this.getStatuses().isEmpty()) {
                arguments.put("status", "any");
            } else if (!onlyContainsCurrent) {
                List statusList = this.getStatuses().stream().map(BaseApiEnum::getValue).collect(Collectors.toList());
                arguments.put("status", statusList);
            }
        }

        private WebResource newGraphWebResource() {
            return this.provider.newRestWebResource().path("rest").path("graph");
        }
    }

    public static class GraphQLQueryContentResponse
    extends GraphQLQueryResponse<Map<String, GraphQLPageResponse<Content>>> {
    }
}

