/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.serialization.CustomSerializerModuleFactory;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class RestClientFactory {
    public static Client newClient() {
        return RestClientFactory.newClient(RestClientFactory.createJacksonModule());
    }

    public static Client newClient(Module jacksonModule) {
        Objects.requireNonNull(jacksonModule);
        JacksonJsonProvider provider = RestClientFactory.createProvider(jacksonModule);
        ClientConfig config = RestClientFactory.createConfig(provider);
        return Client.create((ClientConfig)config);
    }

    public static Client newClient(Object provider, Object ... providers) {
        Objects.requireNonNull(provider);
        Object[] providerArray = Stream.concat(Stream.of(provider), Stream.of(providers)).toArray();
        ClientConfig clientConfig = RestClientFactory.createConfig(providerArray);
        return Client.create((ClientConfig)clientConfig);
    }

    public static ClientConfig createConfig(Object ... providers) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        for (Object provider : providers) {
            Class<?> clazz = provider.getClass();
            while (!Object.class.equals(clazz) && !clazz.isAnnotationPresent(Provider.class)) {
                clazz = clazz.getSuperclass();
            }
            if (clazz.equals(Object.class)) {
                throw new IllegalArgumentException(provider.getClass() + " is not annotated with " + Provider.class);
            }
            clientConfig.getSingletons().add(provider);
        }
        clientConfig.getClasses().add(MultiPartWriter.class);
        return clientConfig;
    }

    public static Module createJacksonModule() {
        return CustomSerializerModuleFactory.create();
    }

    public static JacksonJsonProvider createProvider(@Nullable Module jacksonModule) {
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider(){

            public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
                try {
                    int buffersize_512kB = 524288;
                    entityStream = new BufferedInputStream(entityStream);
                    entityStream.mark(524288);
                    return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
                }
                catch (JsonProcessingException ex) {
                    entityStream.reset();
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)entityStream, (Writer)writer);
                    throw new ServiceException("Json process exception encountered in client reading entity stream : " + ((Object)writer).toString(), (Throwable)ex);
                }
            }
        };
        provider.configure(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES, false);
        if (jacksonModule != null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule(jacksonModule);
            provider.setMapper(mapper);
        }
        return provider;
    }
}

