/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.watch.ContentWatch;
import com.atlassian.confluence.api.model.watch.SpaceWatch;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.watch.WatchService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteWatchService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.sal.api.user.UserKey;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.core.MultivaluedMap;

public class RemoteWatchServiceImpl
extends AbstractRemoteService<WatchService>
implements RemoteWatchService {
    public RemoteWatchServiceImpl(AuthenticatedWebResourceProvider provider, ExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public WatchService.Validator validator() {
        throw new NotImplementedServiceException("WatchService.validator() not supported");
    }

    @Override
    public CompletionStage<SpaceWatch> watchSpaceCompletionStage(UserKey userKey, String spaceKey, List<ContentType> contentTypes) {
        return this.postCompletionStage(this.userWatchResource(userKey, contentTypes).path("space").path(spaceKey), SpaceWatch.class, null);
    }

    @Override
    public CompletionStage<Void> unwatchSpaceCompletionStage(UserKey userKey, String spaceKey, List<ContentType> contentTypes) {
        return this.deleteCompletionStage(this.userWatchResource(userKey, contentTypes).path("space").path(spaceKey));
    }

    @Override
    public CompletionStage<Boolean> isWatchingSpaceCompletionStage(UserKey userKey, String spaceKey, ContentType contentType) {
        return this.getCompletionStage(this.userWatchResource(userKey, contentType).path("space").path(spaceKey), Map.class).thenApplyAsync(item -> (Boolean)item.get("watching"), this.getExecutor());
    }

    @Override
    public CompletionStage<SpaceWatch> watchSpaceCompletionStage(UserKey userKey, String spaceKey) {
        return this.postCompletionStage(this.userWatchResource(userKey).path("space").path(spaceKey), SpaceWatch.class, null);
    }

    @Override
    public CompletionStage<Boolean> isWatchingSpaceCompletionStage(UserKey userKey, String spaceKey) {
        return this.getCompletionStage(this.userWatchResource(userKey).path("space").path(spaceKey), Map.class).thenApplyAsync(item -> (Boolean)item.get("watching"), this.getExecutor());
    }

    @Override
    public CompletionStage<Void> unwatchSpaceCompletionStage(UserKey userKey, String spaceKey) {
        return this.deleteCompletionStage(this.userWatchResource(userKey).path("space").path(spaceKey));
    }

    @Override
    public CompletionStage<ContentWatch> watchContentCompletionStage(UserKey userKey, ContentId contentId) {
        return this.postCompletionStage(this.userWatchResource(userKey).path("content").path(contentId.serialise()), ContentWatch.class, null);
    }

    @Override
    public CompletionStage<Void> unwatchContentCompletionStage(UserKey userKey, ContentId contentId) {
        return this.deleteCompletionStage(this.userWatchResource(userKey).path("content").path(contentId.serialise()));
    }

    @Override
    public CompletionStage<Boolean> isWatchingContentCompletionStage(UserKey userKey, ContentId contentId) {
        return this.getCompletionStage(this.userWatchResource(userKey).path("content").path(contentId.serialise()), Map.class).thenApplyAsync(item -> (Boolean)item.get("watching"), this.getExecutor());
    }

    @Override
    public CompletionStage<PageResponse<User>> findUsersWatchingSpacePaginated(String spaceKey, PageRequest pageRequest) {
        String path = String.format("/space/%s/watchers", spaceKey);
        WebResource resource = this.newRestWebResource().path(path);
        return this.getCompletionStagePageResponseList(resource, User.class);
    }

    @Override
    public CompletionStage<PageResponse<User>> findUsersWatchingContentPaginated(ContentId contentId, PageRequest pageRequest) {
        String path = String.format("/content/%s/watchers", contentId.asLong());
        WebResource resource = this.newRestWebResource().path(path);
        return this.getCompletionStagePageResponseList(resource, User.class);
    }

    private WebResource userWatchResource(UserKey userKey) {
        return this.userWatchResource(userKey, new ArrayList<ContentType>());
    }

    private WebResource userWatchResource(UserKey userKey, ContentType contentType) {
        return this.newRestWebResource().path("user").path("watch").queryParam("key", userKey.getStringValue()).queryParam("contentType", contentType.getType());
    }

    private WebResource userWatchResource(UserKey userKey, List<ContentType> contentTypes) {
        WebResource webResource = this.newRestWebResource().path("user").path("watch");
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"key", (Object)userKey.getStringValue());
        contentTypes.forEach(arg_0 -> RemoteWatchServiceImpl.lambda$userWatchResource$3((MultivaluedMap)params, arg_0));
        webResource = webResource.queryParams((MultivaluedMap)params);
        return webResource;
    }

    private static /* synthetic */ void lambda$userWatchResource$3(MultivaluedMap params, ContentType contentType) {
        params.add((Object)"contentType", (Object)contentType.getType());
    }
}

