/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.remoteservice.webfragment.graphql;

import com.atlassian.confluence.api.model.web.WebItemView;
import com.atlassian.confluence.api.model.web.WebPanelView;
import com.atlassian.confluence.api.model.web.WebSectionView;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.graphql.GraphQLQueryResponse;
import com.atlassian.confluence.rest.client.graphql.GraphQLUtils;
import com.atlassian.confluence.rest.client.remoteservice.webfragment.AbstractRemoteWebView;
import com.atlassian.confluence.rest.client.remoteservice.webfragment.RemoteWebView;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class GraphQLRemoteWebViewImpl
extends AbstractRemoteWebView
implements RemoteWebView {
    private static final String WEB_ITEM_FIELDS = "url\nlabel\nweight\nmoduleKey\nid\naccessKey\ncompleteKey\nsection\ntooltip\nstyleClass\nurlWithoutContextPath\nicon { path width height isDefault }\nparams { key value }\n";
    private static final String WEB_PANEL_FIELDS = "moduleKey\ncompleteKey\nhtml\nlocation\nlabel\nweight\nname\n";

    GraphQLRemoteWebViewImpl(AbstractRemoteService delegate) {
        super(delegate);
    }

    @Override
    public CompletionStage<Iterable<WebItemView>> getItemsForSectionCompletionStage(String section, Map<String, Object> additionalContext) {
        String requestString = this.buildItemsForSectionRequestString(section, additionalContext);
        CompletionStage<GraphQLWebItemsResponse> responsePromise = this.postCompletionStage(this.newGraphWebResource(), GraphQLWebItemsResponse.class, requestString);
        return responsePromise.thenApplyAsync(response -> {
            response.throwFirstErrorIfExists();
            List webItems = (List)((Map)response.getData()).get("webItems");
            if (webItems.isEmpty()) {
                throw new NotFoundException();
            }
            return webItems;
        }, this.getExecutor());
    }

    private String buildItemsForSectionRequestString(String section, Map<String, Object> additionalContext) {
        String[] parts = section.split("/");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("location", parts[0]);
        variables.put("section", parts[1]);
        variables.putAll(additionalContext);
        String query = "{\n  webItems" + GraphQLUtils.buildGraphQLFieldArgumentsString(variables) + " {\n" + WEB_ITEM_FIELDS + "  }}";
        return GraphQLUtils.buildRequestString(query);
    }

    @Override
    public CompletionStage<Iterable<WebSectionView>> getSectionsForLocationCompletionStage(String location, Map<String, Object> additionalContext) {
        return this.getSectionsForLocationsCompletionStage(new ArrayList<String>(Collections.singleton(location)), additionalContext);
    }

    @Override
    public CompletionStage<Iterable<WebSectionView>> getSectionsForLocationsCompletionStage(Collection<String> locations, Map<String, Object> additionalContext) {
        String requestString = this.buildSectionsForLocationsRequestString(locations, additionalContext);
        CompletionStage<GraphQLWebSectionsResponse> responsePromise = this.postCompletionStage(this.newGraphWebResource(), GraphQLWebSectionsResponse.class, requestString);
        return responsePromise.thenApplyAsync(response -> {
            response.throwFirstErrorIfExists();
            List webItemSections = (List)((Map)response.getData()).get("webItemSections");
            if (webItemSections.isEmpty()) {
                throw new NotFoundException();
            }
            return webItemSections;
        }, this.getExecutor());
    }

    private String buildSectionsForLocationsRequestString(Collection<String> locations, Map<String, Object> additionalContext) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("locations", locations);
        variables.putAll(additionalContext);
        String query = "{\n  webItemSections" + GraphQLUtils.buildGraphQLFieldArgumentsString(variables) + " {\n    id\n    label\n    styleClass\n    items {\n" + WEB_ITEM_FIELDS + "    }\n  }\n}";
        return GraphQLUtils.buildRequestString(query);
    }

    @Override
    public CompletionStage<Iterable<WebPanelView>> getPanelsForLocationCompletionStage(String location, Map<String, Object> additionalContext) {
        return this.getPanelsForLocationsCompletionStage(new ArrayList<String>(Collections.singleton(location)), additionalContext);
    }

    @Override
    public CompletionStage<Iterable<WebPanelView>> getPanelsForLocationsCompletionStage(Collection<String> locations, Map<String, Object> additionalContext) {
        String requestString = this.buildPanelsForLocationsRequestString(locations, additionalContext);
        CompletionStage<GraphQLWebPanelsResponse> responsePromise = this.postCompletionStage(this.newGraphWebResource(), GraphQLWebPanelsResponse.class, requestString);
        return responsePromise.thenApplyAsync(response -> {
            response.throwFirstErrorIfExists();
            List webItemSections = (List)((Map)response.getData()).get("webPanels");
            if (webItemSections.isEmpty()) {
                throw new NotFoundException();
            }
            return webItemSections;
        }, this.getExecutor());
    }

    private String buildPanelsForLocationsRequestString(Collection<String> locations, Map<String, Object> additionalContext) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("locations", locations);
        variables.putAll(additionalContext);
        String query = "{\n  webPanels" + GraphQLUtils.buildGraphQLFieldArgumentsString(variables) + " {\n" + WEB_PANEL_FIELDS + "  }\n}";
        return GraphQLUtils.buildRequestString(query);
    }

    private WebResource newGraphWebResource() {
        return this.provider.newRestWebResource().path("rest").path("graph");
    }

    public static class GraphQLWebPanelsResponse
    extends GraphQLQueryResponse<Map<String, List<WebPanelView>>> {
    }

    public static class GraphQLWebSectionsResponse
    extends GraphQLQueryResponse<Map<String, List<WebSectionView>>> {
    }

    public static class GraphQLWebItemsResponse
    extends GraphQLQueryResponse<Map<String, List<WebItemView>>> {
    }
}

