/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteCQLSearchService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.net.URLEncoder;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.codehaus.jackson.map.ObjectMapper;

public class RemoteCQLSearchServiceImpl
extends AbstractRemoteService<CQLSearchService>
implements RemoteCQLSearchService {
    private static final String CQLCONTEXT_QUERY_PARAM = "cqlcontext";
    private static final String CQL_QUERY_PARAM = "cql";

    public RemoteCQLSearchServiceImpl(AuthenticatedWebResourceProvider provider, ExecutorService executor) {
        super(provider, executor);
    }

    @Deprecated
    public RemoteCQLSearchServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, (ExecutorService)executor);
    }

    @Override
    public CompletionStage<SearchPageResponse<Content>> searchContentCompletionStage(String cqlInput, SearchContext searchContext, PageRequest pageRequest, Expansion ... expansions) {
        return this.searchContentInternalCompletionStage(cqlInput, searchContext, pageRequest, expansions);
    }

    @Override
    public CompletionStage<SearchPageResponse<Content>> searchContentCompletionStage(String cql, PageRequest request, Expansion ... expansions) {
        return this.searchContentInternalCompletionStage(cql, null, request, expansions);
    }

    @Override
    public CompletionStage<SearchPageResponse<Content>> searchContentCompletionStage(String cql, Expansion ... expansions) {
        return this.searchContentInternalCompletionStage(cql, null, null, expansions);
    }

    @Override
    public int countContent(String cql) {
        throw new NotImplementedServiceException("countContent not implemented by remoteService");
    }

    @Override
    public int countContent(String cql, SearchContext searchContext) {
        throw new NotImplementedServiceException("countContent not implemented by remoteService");
    }

    @Override
    public CompletionStage<Integer> countContentCompletionStage(String cql) {
        return this.searchContentInternalCompletionStage(cql, null, (PageRequest)new SimplePageRequest(0, 0), new Expansion[0]).thenApplyAsync(SearchPageResponse::size, this.getExecutor());
    }

    @Override
    public CompletionStage<Integer> countContentCompletionStage(String cql, SearchContext searchContext) {
        return this.searchContentInternalCompletionStage(cql, searchContext, (PageRequest)new SimplePageRequest(0, 0), new Expansion[0]).thenApplyAsync(SearchPageResponse::size, this.getExecutor());
    }

    @Override
    public CompletionStage<SearchPageResponse<SearchResult>> searchCompletionStage(String cql, SearchOptions searchOptions, PageRequest pageRequest, Expansion ... expansions) {
        WebResource webResource = this.newRestWebResource().path("search");
        webResource = webResource.queryParam(CQL_QUERY_PARAM, cql);
        webResource = this.addPageRequestParams(webResource, pageRequest);
        webResource = this.addExpansions(webResource, expansions);
        webResource = webResource.queryParam("excerpt", searchOptions.getExcerptStrategy().serialise());
        webResource = webResource.queryParam("includeArchivedSpaces", Boolean.toString(searchOptions.isIncludeArchivedSpaces()));
        return this.getCompletionStageSearchPageResponseList(webResource, SearchResult.class);
    }

    private CompletionStage<SearchPageResponse<Content>> searchContentInternalCompletionStage(String cqlInput, @Nullable SearchContext searchContext, @Nullable PageRequest request, Expansion ... expansions) {
        WebResource resource = this.getContentSearchWebResource();
        if (searchContext != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                String serializedSearchContext = mapper.writeValueAsString((Object)searchContext);
                resource = resource.queryParam(CQLCONTEXT_QUERY_PARAM, URLEncoder.encode(serializedSearchContext, "UTF-8"));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        resource = this.addExpansions(resource, expansions);
        if (request != null) {
            resource = this.addPageRequest(resource, request);
        }
        resource = resource.queryParam(CQL_QUERY_PARAM, cqlInput);
        return this.getCompletionStageSearchPageResponseList(resource, Content.class);
    }

    private WebResource getContentSearchWebResource() {
        return this.newRestWebResource().path("content").path("search");
    }
}

