/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.graphql;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.GraphQLQueryExpansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.client.AbstractRemoteChildContentService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteChildContentService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.graphql.GraphQLQueryResponse;
import com.atlassian.confluence.rest.client.graphql.GraphQLUtils;
import com.atlassian.confluence.rest.serialization.graphql.GraphQLPageResponse;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.Nullable;

@Internal
public class GraphQLRemoteChildContentServiceImpl
extends AbstractRemoteChildContentService
implements RemoteChildContentService {
    private final String defaultGraphQLQuery;

    public GraphQLRemoteChildContentServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor, String defaultGraphQLQuery) {
        super(provider, executor);
        this.defaultGraphQLQuery = defaultGraphQLQuery;
    }

    @Override
    public RemoteChildContentService.RemoteChildContentFinder findContent(ContentId parentId, Expansion ... expansion) {
        return new RemoteChildContentFinderImpl(this, parentId, expansion);
    }

    public static class GraphQLQueryChildContentResponse
    extends GraphQLQueryResponse<Map<String, Map<String, List<Map<String, GraphQLPageResponse<Content>>>>>> {
    }

    public class RemoteChildContentFinderImpl
    extends AbstractRemoteChildContentService.AbstractRemoteChildContentFinder
    implements RemoteChildContentService.RemoteChildContentFinder {
        private String graphqlQuery;
        private ContentId parentId;

        public RemoteChildContentFinderImpl(AbstractRemoteService other, ContentId parentId, Expansion[] expansions) {
            super(other);
            this.graphqlQuery = GraphQLRemoteChildContentServiceImpl.this.defaultGraphQLQuery;
            this.parentId = parentId;
            if (expansions.length != 0) {
                if (expansions.length > 1 || !(expansions[0] instanceof GraphQLQueryExpansion)) {
                    throw new IllegalArgumentException("Expected a single expansion of type '" + GraphQLQueryExpansion.class.getSimpleName() + "'");
                }
                this.graphqlQuery = ((GraphQLQueryExpansion)expansions[0]).getQuery();
            }
        }

        @Override
        public CompletionStage<Map<ContentType, PageResponse<Content>>> fetchMappedByTypeCompletionStage(PageRequest request) {
            throw new NotImplementedServiceException("Not yet implemented for GraphQL client");
        }

        @Override
        public CompletionStage<PageResponse<Content>> fetchManyCompletionStage(ContentType type, PageRequest request) {
            String queryFieldName = type == ContentType.COMMENT ? "comments" : "children";
            String requestString = this.buildFetchManyRequestString(type, request, queryFieldName);
            CompletionStage<GraphQLQueryChildContentResponse> responsePromise = this.postCompletionStage(this.newGraphWebResource(), GraphQLQueryChildContentResponse.class, requestString);
            return responsePromise.thenApplyAsync(response -> {
                response.throwFirstErrorIfExists();
                return (PageResponse)((Map)((List)((Map)((Map)response.getData()).get("content")).get("nodes")).get(0)).get(queryFieldName);
            }, this.getExecutor());
        }

        private String buildFetchManyRequestString(ContentType type, @Nullable PageRequest request, String queryFieldName) {
            HashMap<String, Object> queryArguments = new HashMap<String, Object>();
            if (request != null) {
                queryArguments.put("offset", request.getStart());
                queryArguments.put("first", request.getLimit());
            }
            if (type != null && !type.equals((Object)ContentType.COMMENT)) {
                queryArguments.put("type", type.getType());
            }
            if (this.parentVersion != 0) {
                queryArguments.put("parentVersion", this.parentVersion);
            }
            if (this.location != null) {
                queryArguments.put("location", this.location);
            }
            if (this.depth != null) {
                queryArguments.put("depth", this.getDepthString(this.depth));
            }
            String query = "{\n  content(id: \"" + this.parentId.asLong() + "\") {\n  nodes " + GraphQLUtils.buildQuery(queryFieldName, this.graphqlQuery, queryArguments) + "\n  }\n}";
            return GraphQLUtils.buildRequestString(query);
        }

        private String getDepthString(Depth depth) {
            if (depth == Depth.ROOT) {
                return "root";
            }
            if (depth == Depth.ALL) {
                return "all";
            }
            throw new NotImplementedServiceException("Only ROOT and ALL depth is currently supported");
        }

        private WebResource newGraphWebResource() {
            return this.provider.newRestWebResource().path("rest").path("graph");
        }
    }
}

