/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.service.content.ContentTrashService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.RemoteContentServiceImpl;
import com.atlassian.confluence.rest.client.RemoteContentTrashService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;

public class RemoteContentTrashServiceImpl
extends AbstractRemoteService<ContentTrashService>
implements RemoteContentTrashService {
    private final RemoteContentService remoteContentService;

    public RemoteContentTrashServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, (ExecutorService)executor);
        this.remoteContentService = new RemoteContentServiceImpl(provider, executor);
    }

    @Override
    public CompletionStage<Void> trashCompletionStage(Content content) {
        WebResource resource = this.getContentTrashWebResource().path(content.getId().serialise());
        return this.deleteCompletionStage(resource);
    }

    @Override
    public CompletionStage<Content> restoreCompletionStage(Content content) {
        return this.remoteContentService.updateCompletionStage(content);
    }

    @Override
    public CompletionStage<Void> purgeCompletionStage(Content content) {
        WebResource resource = this.getContentTrashWebResource().path(content.getId().serialise()).queryParam("status", "trashed");
        return this.deleteCompletionStage(resource);
    }

    private WebResource getContentTrashWebResource() {
        return this.newRestWebResource().path("content");
    }
}

