/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.template.ContentBlueprintInstance;
import com.atlassian.confluence.api.model.content.template.ContentTemplate;
import com.atlassian.confluence.api.model.content.template.ContentTemplateId;
import com.atlassian.confluence.api.model.content.template.ContentTemplateType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.template.ContentTemplateService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentTemplateService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.util.PromiseUtils;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;

public class RemoteContentTemplateServiceImpl
extends AbstractRemoteService<ContentTemplateService>
implements RemoteContentTemplateService {
    private final ContentTemplateType templateType;

    public RemoteContentTemplateServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executorService, ContentTemplateType templateType) {
        super(provider, (ExecutorService)executorService);
        this.templateType = templateType;
    }

    @Override
    public CompletionStage<PageResponse<ContentTemplate>> getTemplatesCompletionStage(ContentTemplateType contentTemplateType, Optional<Space> space, PageRequest pageRequest, Expansion ... expansions) {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path(contentTemplateType.getType());
        if (space.isPresent()) {
            webResource = webResource.queryParam("spaceKey", space.get().getKey());
        }
        webResource = this.addPageRequest(webResource, pageRequest);
        this.addExpansions(webResource, expansions);
        return this.getCompletionStagePageResponseList(webResource, ContentTemplate.class);
    }

    private WebResource getWebResource() {
        return this.newExperimentalRestWebResource().path("template");
    }

    @Override
    @Deprecated
    public Promise<ContentTemplate> getTemplate(ContentTemplateId contentTemplateId, Expansion ... expansions) {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path(contentTemplateId.serialise());
        webResource = this.addExpansions(webResource, expansions);
        return this.getFuture(webResource, ContentTemplate.class);
    }

    @Override
    public CompletionStage<ContentTemplate> getTemplateCompletionStage(ContentTemplateId contentTemplateId, Expansion ... expansions) {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path(contentTemplateId.serialise());
        webResource = this.addExpansions(webResource, expansions);
        return this.getCompletionStage(webResource, ContentTemplate.class);
    }

    @Override
    @Deprecated
    public Promise<ContentTemplate> create(ContentTemplate contentTemplate, Expansion ... expansions) {
        WebResource resource = this.getWebResource();
        resource = this.addExpansions(resource, expansions);
        return this.postFuture(resource, ContentTemplate.class, contentTemplate);
    }

    @Override
    @Deprecated
    public Promise<ContentTemplate> update(ContentTemplate contentTemplate, Expansion ... expansions) {
        WebResource resource = this.getWebResource();
        resource = this.addExpansions(resource, expansions);
        return this.putFuture(resource, ContentTemplate.class, contentTemplate);
    }

    @Override
    @Deprecated
    public Promise<Void> delete(ContentTemplateId contentTemplateId) {
        WebResource resource = this.getWebResource();
        resource = resource.path(contentTemplateId.serialise());
        return this.deleteFuture(resource);
    }

    @Override
    public CompletionStage<ContentTemplate> createCompletionStage(ContentTemplate contentTemplate, Expansion ... expansions) {
        WebResource resource = this.getWebResource();
        resource = this.addExpansions(resource, expansions);
        return this.postCompletionStage(resource, ContentTemplate.class, contentTemplate);
    }

    @Override
    public CompletionStage<ContentTemplate> updateCompletionStage(ContentTemplate contentTemplate, Expansion ... expansions) {
        WebResource resource = this.getWebResource();
        resource = this.addExpansions(resource, expansions);
        return this.putCompletionStage(resource, ContentTemplate.class, contentTemplate);
    }

    @Override
    public CompletionStage<Void> deleteCompletionStage(ContentTemplateId contentTemplateId) {
        WebResource resource = this.getWebResource();
        resource = resource.path(contentTemplateId.serialise());
        return this.deleteCompletionStage(resource);
    }

    @Override
    public RemoteContentTemplateService.RemoteTemplateFinder find(Expansion ... expansions) {
        return new RemoteTemplateFinderImpl(this, expansions);
    }

    @Override
    @Deprecated
    public Promise<ContentBlueprintInstance> createInstance(ContentBlueprintInstance contentBlueprintInstance, Expansion ... expansions) {
        WebResource webResource = this.getWebResource().path(this.templateType.getType());
        ContentTemplateId contentTemplateId = (ContentTemplateId)contentBlueprintInstance.getContentBlueprintSpec().contentTemplateId().get();
        webResource = webResource.path(contentTemplateId.serialise()).path("instance");
        webResource = this.addExpansions(webResource, expansions);
        return this.postFuture(webResource, ContentBlueprintInstance.class, contentBlueprintInstance);
    }

    @Override
    public CompletionStage<ContentBlueprintInstance> createInstanceCompletionStage(ContentBlueprintInstance contentBlueprintInstance, Expansion ... expansions) {
        WebResource webResource = this.getWebResource().path(this.templateType.getType());
        ContentTemplateId contentTemplateId = (ContentTemplateId)contentBlueprintInstance.getContentBlueprintSpec().contentTemplateId().get();
        webResource = webResource.path(contentTemplateId.serialise()).path("instance");
        webResource = this.addExpansions(webResource, expansions);
        return this.postCompletionStage(webResource, ContentBlueprintInstance.class, contentBlueprintInstance);
    }

    public class RemoteTemplateFinderImpl
    extends AbstractRemoteService<ContentTemplateService.TemplateFinder>
    implements RemoteContentTemplateService.RemoteTemplateFinder {
        private final Expansion[] expansions;
        private ContentTemplateId contentTemplateId;
        private Optional<Space> space;

        RemoteTemplateFinderImpl(RemoteContentTemplateServiceImpl service, Expansion ... expansions) {
            super(service);
            this.space = Optional.empty();
            this.expansions = expansions;
        }

        @Override
        public RemoteContentTemplateService.RemoteSingleTemplateFetcher withId(ContentTemplateId contentTemplateId) {
            this.contentTemplateId = contentTemplateId;
            return this;
        }

        @Override
        public RemoteContentTemplateService.RemoteParameterTemplateFinder withSpace(Space space) {
            if (space != null) {
                this.space = Optional.of(space);
            }
            return this;
        }

        @Override
        @Deprecated
        public Promise<PageResponse<ContentTemplate>> fetchMany(PageRequest request) {
            WebResource webResource = RemoteContentTemplateServiceImpl.this.getWebResource().path(RemoteContentTemplateServiceImpl.this.templateType.getType());
            if (this.space.isPresent()) {
                webResource = webResource.queryParam("spaceKey", this.space.get().getKey());
            }
            webResource = this.addPageRequest(webResource, request);
            webResource = this.addExpansions(webResource, this.expansions);
            return this.getFuturePageResponseList(webResource, ContentTemplate.class);
        }

        @Override
        public CompletionStage<PageResponse<ContentTemplate>> fetchManyCompletionStage(PageRequest request) {
            WebResource webResource = RemoteContentTemplateServiceImpl.this.getWebResource().path(RemoteContentTemplateServiceImpl.this.templateType.getType());
            if (this.space.isPresent()) {
                webResource = webResource.queryParam("spaceKey", this.space.get().getKey());
            }
            webResource = this.addPageRequest(webResource, request);
            webResource = this.addExpansions(webResource, this.expansions);
            return this.getCompletionStagePageResponseList(webResource, ContentTemplate.class);
        }

        @Override
        @Deprecated
        public Promise<Option<ContentTemplate>> fetchOne() {
            return PromiseUtils.toPromiseOption(this.fetchCompletionStage(), this.getExecutor());
        }

        @Override
        @Deprecated
        public Promise<ContentTemplate> fetchOneOrNull() {
            return PromiseUtils.toPromise(this.fetchOrNullCompletionStage());
        }

        @Override
        public CompletionStage<Optional<ContentTemplate>> fetchCompletionStage() {
            if (this.contentTemplateId != null) {
                WebResource webResource = RemoteContentTemplateServiceImpl.this.getWebResource().path(this.contentTemplateId.serialise());
                webResource = this.addExpansions(webResource, this.expansions);
                return this.getCompletionStageOptional(webResource, ContentTemplate.class);
            }
            return this.fetchManyCompletionStage(SimplePageRequest.ONE).thenApplyAsync(input -> {
                if (input.size() > 0) {
                    return Optional.of((ContentTemplate)input.iterator().next());
                }
                return Optional.empty();
            }, this.getExecutor());
        }

        @Override
        public CompletionStage<ContentTemplate> fetchOrNullCompletionStage() {
            return this.fetchCompletionStage().thenApplyAsync(opt -> opt.orElse(null), this.getExecutor());
        }
    }
}

