/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.relations.Relatable;
import com.atlassian.confluence.api.model.relations.RelationDescriptor;
import com.atlassian.confluence.api.model.relations.RelationInstance;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.relations.RelationService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteRelationService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;

public class RemoteRelationServiceImpl
extends AbstractRemoteService<RelationService>
implements RemoteRelationService {
    public RemoteRelationServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, (ExecutorService)executor);
    }

    @Override
    @Deprecated
    public <S extends Relatable, T extends Relatable> Promise<Void> create(RelationInstance<S, T> relationInstance) throws ServiceException {
        return this.putFuture(this.newWebResource(relationInstance), Void.class, null).map(result -> null);
    }

    @Override
    @Deprecated
    public <S extends Relatable, T extends Relatable> Promise<Void> delete(RelationInstance<S, T> relationInstance) throws ServiceException {
        return this.deleteFuture(this.newWebResource(relationInstance));
    }

    @Override
    public <S extends Relatable, T extends Relatable> CompletionStage<Void> createCompletionStage(RelationInstance<S, T> relationInstance) throws ServiceException {
        return this.putCompletionStage(this.newWebResource(relationInstance), Void.class, null).thenApplyAsync(result -> null, this.getExecutor());
    }

    @Override
    public <S extends Relatable, T extends Relatable> CompletionStage<Void> deleteCompletionStage(RelationInstance<S, T> relationInstance) throws ServiceException {
        return this.deleteCompletionStage(this.newWebResource(relationInstance));
    }

    @Override
    @Deprecated
    public <S extends Relatable, T extends Relatable> Promise<Boolean> isRelated(S source, RelationDescriptor<S, T> relationDescriptor, T target) {
        return this.getFutureOptional(this.newWebResource(source, relationDescriptor, target), Void.class).map(Optional::isPresent);
    }

    @Override
    public <S extends Relatable, T extends Relatable> CompletionStage<Boolean> isRelatedCompletionStage(S source, RelationDescriptor<S, T> relationDescriptor, T target) {
        CompletionStage<Optional<Void>> stage = this.getCompletionStageOptional(this.newWebResource(source, relationDescriptor, target), Void.class);
        return stage.thenApplyAsync(Optional::isPresent, this.getExecutor());
    }

    private <S extends Relatable, T extends Relatable> WebResource newWebResource(RelationInstance<S, T> relationInstance) throws ServiceException {
        Objects.requireNonNull(relationInstance, "relationInstance");
        return this.newWebResource(relationInstance.getSource(), relationInstance.getRelationDescriptor(), relationInstance.getTarget());
    }

    private <S extends Relatable, T extends Relatable> WebResource newWebResource(S source, RelationDescriptor<S, T> relationDescriptor, T target) throws ServiceException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(relationDescriptor, "relationDescriptor");
        Objects.requireNonNull(target, "target");
        WebResource webResource = this.newExperimentalRestWebResource().path("/relation").path(this.getSourceEntityName(source)).path(this.getEntityIdentifier(source)).path(relationDescriptor.getRelationName()).path(this.getTargetEntityName(target)).path(this.getEntityIdentifier(target));
        webResource = this.addContentStatusQueryParam(webResource, source, "source");
        webResource = this.addContentStatusQueryParam(webResource, target, "target");
        webResource = this.addContentVersionQueryParam(webResource, source, "source");
        webResource = this.addContentVersionQueryParam(webResource, target, "target");
        return webResource;
    }

    private WebResource addContentStatusQueryParam(WebResource webResource, Relatable entity, String side) {
        if (entity instanceof Content && ((Content)entity).getStatus() != null) {
            Content content = (Content)entity;
            webResource = webResource.queryParam(side + "Status", content.getStatus().serialise());
        }
        return webResource;
    }

    private WebResource addContentVersionQueryParam(WebResource webResource, Relatable entity, String side) {
        if (entity instanceof Content && ContentStatus.HISTORICAL.equals((Object)((Content)entity).getStatus())) {
            Content content = (Content)entity;
            webResource = webResource.queryParam(side + "Version", String.valueOf(content.getVersion().getNumber()));
        }
        return webResource;
    }

    private String getSourceEntityName(Relatable entity) {
        return this.getEntityName(entity, "source");
    }

    private String getTargetEntityName(Relatable entity) {
        String name = this.getEntityName(entity, "target");
        return "to" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private String getEntityName(Relatable entity, String side) {
        if (entity instanceof User) {
            return "user";
        }
        if (entity instanceof Space) {
            return "space";
        }
        if (entity instanceof Content) {
            return "content";
        }
        throw new BadRequestException("Expected a User, Space or Content as the " + side);
    }

    private String getEntityIdentifier(Relatable entity) {
        if (entity instanceof User) {
            return this.getUserKey((User)entity);
        }
        if (entity instanceof Space) {
            return this.getSpaceKey((Space)entity);
        }
        if (entity instanceof Content) {
            return this.getContentId((Content)entity);
        }
        throw new BadRequestException();
    }

    private String getUserKey(User user) {
        Optional userKey = user.optionalUserKey();
        if (!userKey.isPresent() || ((UserKey)userKey.get()).getStringValue().isEmpty()) {
            throw new BadRequestException("UserKey field missing from User specification");
        }
        return ((UserKey)userKey.get()).getStringValue();
    }

    private String getSpaceKey(Space space) {
        if (space.getKey() == null || space.getKey().isEmpty()) {
            throw new BadRequestException("Key field missing from Space specification");
        }
        return space.getKey();
    }

    private String getContentId(Content content) {
        if (content.getId() == null) {
            throw new BadRequestException("Id field missing from Content specification");
        }
        return content.getId().serialise();
    }
}

