/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.service.content.ContentVersionService;
import com.atlassian.confluence.api.service.content.VersionRestoreParameters;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentVersionService;
import com.atlassian.confluence.rest.client.RemoteSingleFetcher;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.util.PromiseUtils;
import com.atlassian.confluence.rest.serialization.RestData;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;

public class RemoteContentVersionServiceImpl
extends AbstractRemoteService<ContentVersionService>
implements RemoteContentVersionService {
    public static final String VERSION = "version";

    public RemoteContentVersionServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executorService) {
        super(provider, (ExecutorService)executorService);
    }

    @Override
    public RemoteContentVersionService.RemoteVersionFinder find(Expansion ... expansions) {
        return new RemoteVersionFinderImpl(this, expansions);
    }

    @Override
    public CompletionStage<Void> deleteCompletionStage(ContentId contentId, int versionNumber) {
        WebResource webResource = this.getWebResource(contentId).path(String.valueOf(versionNumber));
        return this.deleteCompletionStage(webResource);
    }

    @Override
    public CompletionStage<Version> restoreCompletionStage(ContentId contentId, VersionRestoreParameters versionRestoreParameters, Expansion ... expansions) {
        WebResource webResource = this.getWebResource(contentId);
        webResource = this.addExpansions(webResource, expansions);
        RestData restData = RestData.builder().operation(OperationKey.RESTORE).params(versionRestoreParameters.toMap()).build();
        return this.postCompletionStage(webResource, Version.class, restData);
    }

    private WebResource getWebResource(ContentId contentId) {
        return this.newExperimentalRestWebResource().path("content").path(contentId.serialise()).path(VERSION);
    }

    public class RemoteVersionFinderImpl
    extends AbstractRemoteService<ContentVersionService.VersionFinder>
    implements RemoteContentVersionService.RemoteVersionFinder {
        private final Expansion[] expansions;
        private ContentId contentId;
        private int version;

        RemoteVersionFinderImpl(RemoteContentVersionServiceImpl service, Expansion ... expansions) {
            super(service);
            this.expansions = expansions;
        }

        @Override
        public RemoteSingleFetcher withIdAndVersion(ContentId contentId, int version) {
            this.contentId = contentId;
            this.version = version;
            return this;
        }

        @Override
        @Deprecated
        public Promise<PageResponse<Version>> fetchMany(PageRequest pageRequest) {
            WebResource webResource = RemoteContentVersionServiceImpl.this.getWebResource(this.contentId);
            webResource = this.addPageRequest(webResource, pageRequest);
            webResource = this.addExpansions(webResource, this.expansions);
            return this.getFuturePageResponseList(webResource, Version.class);
        }

        @Override
        public CompletionStage<PageResponse<Version>> fetchManyCompletionStage(PageRequest pageRequest) {
            WebResource webResource = RemoteContentVersionServiceImpl.this.getWebResource(this.contentId);
            webResource = this.addPageRequest(webResource, pageRequest);
            webResource = this.addExpansions(webResource, this.expansions);
            return this.getCompletionStagePageResponseList(webResource, Version.class);
        }

        @Override
        public RemoteContentVersionService.RemoteParameterVersionFinder withId(ContentId contentId) {
            this.contentId = contentId;
            return this;
        }

        @Override
        @Deprecated
        public Promise<Option<Version>> fetchOne() {
            return PromiseUtils.toPromiseOption(this.fetchCompletionStage(), this.getExecutor());
        }

        @Override
        @Deprecated
        public Promise<Version> fetchOneOrNull() {
            return PromiseUtils.toPromise(this.fetchOrNullCompletionStage());
        }

        @Override
        public CompletionStage<Optional<Version>> fetchCompletionStage() {
            WebResource webResource = RemoteContentVersionServiceImpl.this.getWebResource(this.contentId).path(String.valueOf(this.version));
            return this.getCompletionStageOptional(webResource, Version.class);
        }

        @Override
        public CompletionStage<Version> fetchOrNullCompletionStage() {
            return this.fetchCompletionStage().thenApplyAsync(opt -> opt.orElse(null), this.getExecutor());
        }
    }
}

