/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.locator.ContentLocator;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.util.JodaTimeUtils;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.util.PromiseUtils;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;

public abstract class AbstractRemoteContentService
extends AbstractRemoteService<ContentService>
implements RemoteContentService {
    private static final Set<String> EXPERIMENTAL_EXPANSIONS = Collections.emptySet();

    public AbstractRemoteContentService(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, (ExecutorService)executor);
    }

    @Override
    @Deprecated
    public Promise<Content> create(Content newContent) {
        return this.create(newContent, new Expansion[0]);
    }

    @Override
    @Deprecated
    public Promise<Content> create(Content newContent, Expansion ... expansions) {
        WebResource resource = this.newContentWebResource();
        resource = this.addExpansions(resource, expansions);
        return this.postFuture(resource, Content.class, newContent);
    }

    @Override
    public CompletionStage<Content> createCompletionStage(Content newContent) {
        return this.createCompletionStage(newContent, new Expansion[0]);
    }

    @Override
    public CompletionStage<Content> createCompletionStage(Content newContent, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.newContentWebResource();
        resource = this.addExpansions(resource, expansions);
        return this.postCompletionStage(resource, Content.class, newContent);
    }

    @Override
    @Deprecated
    public Promise<Content> update(Content content) {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise());
        return this.putFuture(resource, Content.class, content);
    }

    @Override
    @Deprecated
    public Promise<Content> trash(Content content) {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise());
        return this.deleteFuture(resource, Content.class);
    }

    @Override
    @Deprecated
    public Promise<Content> restore(Content content) {
        if (!ContentStatus.CURRENT.equals((Object)content.getStatus())) {
            content = Content.builder((Content)content).status(ContentStatus.CURRENT).build();
        }
        WebResource resource = this.newContentWebResource().path(content.getId().serialise());
        return this.putFuture(resource, Content.class, content);
    }

    @Override
    @Deprecated
    public Promise<Void> purge(Content content) {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise()).queryParam("status", ContentStatus.TRASHED.serialise());
        return this.deleteFuture(resource);
    }

    @Override
    @Deprecated
    public Promise<Void> delete(Content content) {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise());
        return this.deleteFuture(resource);
    }

    @Override
    public CompletionStage<Content> updateCompletionStage(Content content) {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise());
        return this.putCompletionStage(resource, Content.class, content);
    }

    @Override
    public CompletionStage<Content> trashCompletionStage(Content content) {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise());
        return this.deleteCompletionStage(resource, Content.class);
    }

    @Override
    public CompletionStage<Content> restoreCompletionStage(Content content) {
        if (!ContentStatus.CURRENT.equals((Object)content.getStatus())) {
            content = Content.builder((Content)content).status(ContentStatus.CURRENT).build();
        }
        WebResource resource = this.newContentWebResource().path(content.getId().serialise());
        return this.putCompletionStage(resource, Content.class, content);
    }

    @Override
    public CompletionStage<Void> purgeCompletionStage(Content content) {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise()).queryParam("status", ContentStatus.TRASHED.serialise());
        return this.deleteCompletionStage(resource);
    }

    @Override
    public CompletionStage<Void> deleteCompletionStage(Content content) {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise());
        return this.deleteCompletionStage(resource);
    }

    @Override
    @Deprecated
    public Promise<PageResponse<Content>> getChildren(Content parent, PageRequest pageRequest, Expansion ... expansions) {
        WebResource resource = this.newContentWebResource().path(parent.getId().serialise()).path("child");
        resource = this.addExpansions(resource, expansions);
        return this.getFuturePageResponseList(resource, Content.class);
    }

    @Override
    public CompletionStage<PageResponse<Content>> getChildrenCompletionStage(Content parent, PageRequest pageRequest, Expansion ... expansions) {
        WebResource resource = this.newContentWebResource().path(parent.getId().serialise()).path("child");
        resource = this.addExpansions(resource, expansions);
        return this.getCompletionStagePageResponseList(resource, Content.class);
    }

    public WebResource newContentWebResource() {
        return this.newRestWebResource().path("content");
    }

    public WebResource newExperimentalContentWebResource() {
        return this.newExperimentalRestWebResource().path("content");
    }

    protected boolean containsExperimentalExpansion(Expansion[] expansions) {
        for (Expansion expansion : expansions) {
            for (String experimentalExpansion : EXPERIMENTAL_EXPANSIONS) {
                if (!expansion.getPropertyName().equals(experimentalExpansion)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract class AbstractRemoteContentFinder
    extends AbstractRemoteService<ContentService.ContentFinder>
    implements RemoteContentService.RemoteContentFinder {
        protected final Expansion[] expansions;
        protected ContentId contentId;
        protected int version;
        protected String spaceKey;
        protected List<ContentType> contentTypes;
        protected org.joda.time.LocalDate createdDate;
        protected String title;
        @Deprecated
        protected ImmutableList<ContentStatus> statuses;

        protected AbstractRemoteContentFinder(AbstractRemoteContentService otherService, Expansion ... expansions) {
            super(otherService);
            this.contentTypes = Collections.singletonList(ContentType.PAGE);
            this.statuses = ImmutableList.of((Object)ContentStatus.CURRENT);
            this.expansions = expansions;
        }

        @Override
        public RemoteContentService.RemoteSingleContentFetcher withId(ContentId contentId) {
            this.contentId = contentId;
            return this;
        }

        @Override
        public RemoteContentService.RemoteSingleContentFetcher withIdAndVersion(ContentId contentId, int version) {
            this.contentId = contentId;
            this.version = version;
            return this;
        }

        @Override
        public RemoteContentService.RemoteSingleContentFetcher withId(ContentId first, ContentId ... tail) {
            throw new NotImplementedServiceException("Fetching by multiple Ids is not yet supported in the remote client");
        }

        @Override
        public RemoteContentService.RemoteSingleContentFetcher withId(Iterable<ContentId> contentIds) {
            throw new NotImplementedServiceException("Fetching by multiple Ids is not yet supported in the remote client");
        }

        @Override
        public RemoteContentService.RemoteSingleContentFetcher withLocator(ContentLocator locator) {
            this.spaceKey = locator.getSpaceKey();
            this.createdDate = JodaTimeUtils.convert((LocalDate)locator.getPostingDate());
            this.contentTypes = new ArrayList<ContentType>(Arrays.asList(locator.getContentTypes()));
            this.title = locator.getTitle();
            return this;
        }

        @Override
        public RemoteContentService.RemoteParameterContentFinder withSpace(Space ... spaces) {
            this.spaceKey = spaces.length == 1 ? spaces[0].getKey() : null;
            return this;
        }

        @Override
        public RemoteContentService.RemoteParameterContentFinder withType(ContentType ... types) {
            if (types.length > 0) {
                this.contentTypes = new ArrayList<ContentType>(Arrays.asList(types));
            }
            return this;
        }

        @Override
        public RemoteContentService.RemoteParameterContentFinder withCreatedDate(LocalDate time) {
            this.createdDate = JodaTimeUtils.convert((LocalDate)time);
            return this;
        }

        @Override
        public RemoteContentService.RemoteParameterContentFinder withCreatedDate(org.joda.time.LocalDate time) {
            this.createdDate = time;
            return this;
        }

        @Override
        public RemoteContentService.RemoteParameterContentFinder withTitle(String title) {
            this.title = title;
            return this;
        }

        @Override
        public RemoteContentService.RemoteContentFinder withStatus(ContentStatus ... status) {
            this.statuses = ImmutableList.copyOf((Object[])Objects.requireNonNull(status));
            return this;
        }

        @Override
        public RemoteContentService.RemoteContentFinder withAnyStatus() {
            this.statuses = ImmutableList.of();
            return this;
        }

        protected List<ContentStatus> getStatuses() {
            return Collections.unmodifiableList(this.statuses);
        }

        @Override
        public CompletionStage<Map<ContentType, PageResponse<Content>>> fetchMappedByContentTypeCompletionStage(PageRequest request) {
            throw new NotImplementedServiceException("fetchMappedByContentType not yet supported");
        }

        @Override
        @Deprecated
        public Promise<Option<Content>> fetchOne() {
            return PromiseUtils.toPromiseOption(this.fetchCompletionStage(), this.getExecutor());
        }

        @Override
        @Deprecated
        public Promise<Content> fetchOneOrNull() {
            return PromiseUtils.toPromise(this.fetchOrNullCompletionStage());
        }

        @Override
        public CompletionStage<Optional<Content>> fetchCompletionStage() {
            if (this.contentId != null) {
                return this.fetchByIdCompletionStage();
            }
            if (this.contentTypes.isEmpty()) {
                throw new BadRequestException("Cannot fetch content without specifying a contentType or a contentId");
            }
            return this.fetchManyCompletionStage(this.contentTypes.get(0), SimplePageRequest.ONE).thenApplyAsync(input -> {
                if (input.size() > 0) {
                    return Optional.of((Content)input.iterator().next());
                }
                return Optional.empty();
            }, this.getExecutor());
        }

        @Override
        public CompletionStage<Content> fetchOrNullCompletionStage() {
            return this.fetchCompletionStage().thenApplyAsync(opt -> opt.orElse(null), this.getExecutor());
        }

        @Deprecated
        protected abstract Promise<Option<Content>> fetchOneById();

        protected abstract CompletionStage<Optional<Content>> fetchByIdCompletionStage();
    }
}

