/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.client.AbstractRemoteChildContentService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteChildContentService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import io.atlassian.util.concurrent.Promise;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RemoteChildContentServiceImpl
extends AbstractRemoteChildContentService
implements RemoteChildContentService {
    public RemoteChildContentServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public RemoteChildContentService.RemoteChildContentFinder findContent(ContentId parentId, Expansion ... expansion) {
        return new RemoteChildContentFinderImpl(this, parentId, expansion);
    }

    public static class RemoteChildContentFinderImpl
    extends AbstractRemoteChildContentService.AbstractRemoteChildContentFinder
    implements RemoteChildContentService.RemoteChildContentFinder {
        private WebResource resource;

        public RemoteChildContentFinderImpl(AbstractRemoteService other, ContentId parentId, Expansion[] expansion) {
            super(other);
            this.resource = this.newRestWebResource().path("content").path(parentId.serialise());
            this.resource = this.addExpansions(this.resource, expansion);
        }

        @Override
        @Deprecated
        public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByType(@Nullable PageRequest request) {
            this.resource = this.resource.path(this.getPathEndForDepth());
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams(this.resource);
            return this.getFutureMapOfPageResponses(this.resource, ContentType.class, Content.class);
        }

        @Override
        public CompletionStage<Map<ContentType, PageResponse<Content>>> fetchMappedByTypeCompletionStage(PageRequest request) {
            this.resource = this.resource.path(this.getPathEndForDepth());
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams(this.resource);
            return this.getCompletionStageMapOfPageResponses(this.resource, ContentType.class, Content.class);
        }

        @Override
        @Deprecated
        public Promise<PageResponse<Content>> fetchMany(ContentType type, @Nullable PageRequest request) {
            this.resource = this.resource.path(this.getPathEndForDepth());
            this.resource = this.resource.path(type.getType().toLowerCase());
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams(this.resource);
            return this.getFuturePageResponseList(this.resource, Content.class);
        }

        @Override
        public CompletionStage<PageResponse<Content>> fetchManyCompletionStage(ContentType type, PageRequest request) {
            this.resource = this.resource.path(this.getPathEndForDepth());
            this.resource = this.resource.path(type.getType().toLowerCase());
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams(this.resource);
            return this.getCompletionStagePageResponseList(this.resource, Content.class);
        }

        private String getPathEndForDepth() {
            if (this.depth == null || this.depth == Depth.ROOT) {
                return "child";
            }
            if (this.depth == Depth.ALL) {
                return "descendant";
            }
            throw new NotImplementedServiceException("Only ROOT and ALL depth is currently supported");
        }

        private WebResource addParams(WebResource resource) {
            if (this.location != null) {
                for (String locationValue : this.location) {
                    resource = resource.queryParam("location", locationValue);
                }
            }
            if (this.parentVersion != 0) {
                resource = resource.queryParam("parentVersion", String.valueOf(this.parentVersion));
            }
            if (this.depth != null) {
                resource = resource.queryParam("depth", this.depth.toString());
            }
            return resource;
        }
    }
}

