/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.AttachmentUpload;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.AttachmentService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteAttachmentService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.RemoteContentServiceImpl;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.util.PromiseUtils;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.StreamDataBodyPart;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAttachmentServiceImpl
extends AbstractRemoteService<AttachmentService>
implements RemoteAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(RemoteAttachmentServiceImpl.class);
    private final RemoteContentService remoteContentService;

    public RemoteAttachmentServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, (ExecutorService)executor);
        this.remoteContentService = new RemoteContentServiceImpl(provider, executor);
    }

    @Override
    @Deprecated
    public Promise<PageResponse<Content>> addAttachments(ContentId contentId, Collection<AttachmentUpload> uploads) throws ServiceException {
        return this.addAttachments(contentId, ContentStatus.CURRENT, uploads);
    }

    @Override
    @Deprecated
    public Promise<PageResponse<Content>> addAttachments(ContentId contentId, ContentStatus status, Collection<AttachmentUpload> uploads) throws ServiceException {
        WebResource resource = this.newAttachmentWebResource(contentId).queryParam("status", status.getValue());
        FormDataMultiPart multiPart = this.makeMultiPart(uploads);
        return this.postFutureToPageResponse(resource, Content.class, multiPart, MediaType.MULTIPART_FORM_DATA_TYPE);
    }

    @Override
    @Deprecated
    public Promise<PageResponse<Content>> addAttachments(ContentId containerId, ContentStatus containerStatus, Collection<AttachmentUpload> uploads, boolean allowDuplicated, Expansions expansions) throws ServiceException {
        WebResource resource = this.newAttachmentWebResource(containerId).queryParam("status", containerStatus.getValue()).queryParam("allowDuplicated", String.valueOf(allowDuplicated));
        resource = this.addExpansions(resource, expansions == null ? null : expansions.toArray());
        FormDataMultiPart multiPart = this.makeMultiPart(uploads);
        return this.postFutureToPageResponse(resource, Content.class, multiPart, MediaType.MULTIPART_FORM_DATA_TYPE);
    }

    @Override
    public CompletionStage<PageResponse<Content>> addAttachmentsCompletionStage(ContentId contentId, Collection<AttachmentUpload> uploads) throws ServiceException {
        return this.addAttachmentsCompletionStage(contentId, ContentStatus.CURRENT, uploads);
    }

    @Override
    public CompletionStage<PageResponse<Content>> addAttachmentsCompletionStage(ContentId contentId, ContentStatus status, Collection<AttachmentUpload> uploads) throws ServiceException {
        WebResource resource = this.newAttachmentWebResource(contentId).queryParam("status", status.getValue());
        FormDataMultiPart multiPart = this.makeMultiPart(uploads);
        return this.postCompletionStageToPageResponse(resource, Content.class, multiPart, MediaType.MULTIPART_FORM_DATA_TYPE);
    }

    @Override
    public CompletionStage<PageResponse<Content>> addAttachmentsCompletionStage(ContentId containerId, ContentStatus containerStatus, Collection<AttachmentUpload> uploads, boolean allowDuplicated, Expansions expansions) throws ServiceException {
        WebResource resource = this.newAttachmentWebResource(containerId).queryParam("status", containerStatus.getValue()).queryParam("allowDuplicated", String.valueOf(allowDuplicated));
        resource = this.addExpansions(resource, expansions == null ? null : expansions.toArray());
        FormDataMultiPart multiPart = this.makeMultiPart(uploads);
        return this.postCompletionStageToPageResponse(resource, Content.class, multiPart, MediaType.MULTIPART_FORM_DATA_TYPE);
    }

    private WebResource newAttachmentWebResource(ContentId containerId) {
        return this.newRestWebResource().path("content").path(containerId.serialise()).path("child").path("attachment");
    }

    @Override
    public RemoteAttachmentService.RemoteAttachmentFinder find(Expansion ... expansions) {
        return new RemoteAttachmentFinderImpl(this, expansions);
    }

    @Override
    @Deprecated
    public Promise<Content> update(Content attachment) throws ServiceException {
        ContentId containerId = ((Content)attachment.getContainer()).getId();
        WebResource resource = this.newAttachmentWebResource(containerId).path(attachment.getId().serialise());
        return this.putFuture(resource, Content.class, attachment);
    }

    @Override
    @Deprecated
    public Promise<Content> updateData(ContentId attachmentId, AttachmentUpload upload) throws ServiceException {
        Promise byId = this.remoteContentService.find(ExpansionsParser.parseSingle((String)"container")).withId(attachmentId).fetchOne();
        return byId.flatMap(oldAttachmentOption -> {
            Content container = (Content)((Content)oldAttachmentOption.get()).getContainer();
            WebResource resource = this.newAttachmentWebResource(container.getId()).path(attachmentId.serialise()).path("data");
            FormDataMultiPart multiPart = this.makeMultiPart(new ArrayList<AttachmentUpload>(Collections.singleton(upload)));
            Promise<Content> postFuture = this.postFuture(resource, Content.class, multiPart, MediaType.MULTIPART_FORM_DATA_TYPE);
            return Promises.forFuture(postFuture);
        });
    }

    @Override
    @Deprecated
    public Promise<Void> delete(Content attachmentContent) throws ServiceException {
        return this.remoteContentService.delete(attachmentContent);
    }

    @Override
    public CompletionStage<Content> updateCompletionStage(Content attachment) throws ServiceException {
        ContentId containerId = ((Content)attachment.getContainer()).getId();
        WebResource resource = this.newAttachmentWebResource(containerId).path(attachment.getId().serialise());
        return this.putCompletionStage(resource, Content.class, attachment);
    }

    @Override
    public CompletionStage<Content> updateDataCompletionStage(ContentId attachmentId, AttachmentUpload upload) throws ServiceException {
        CompletionStage<Optional<Optional>> byId = this.remoteContentService.find(ExpansionsParser.parseSingle((String)"container")).withId(attachmentId).fetchCompletionStage();
        return byId.thenComposeAsync(oldAttachmentOption -> {
            Content container = (Content)((Content)oldAttachmentOption.get()).getContainer();
            WebResource resource = this.newAttachmentWebResource(container.getId()).path(attachmentId.serialise()).path("data");
            FormDataMultiPart multiPart = this.makeMultiPart(new ArrayList<AttachmentUpload>(Collections.singleton(upload)));
            return this.postCompletionStage(resource, Content.class, multiPart, MediaType.MULTIPART_FORM_DATA_TYPE);
        }, this.getExecutor());
    }

    @Override
    public CompletionStage<Void> deleteCompletionStage(Content attachmentContent) throws ServiceException {
        return this.remoteContentService.deleteCompletionStage(attachmentContent);
    }

    private FormDataMultiPart makeMultiPart(Collection<AttachmentUpload> uploads) {
        FormDataMultiPart multiPart = new FormDataMultiPart();
        for (AttachmentUpload upload : uploads) {
            multiPart.bodyPart(this.makeBodyPart(upload));
            String comment = upload.getComment();
            if (comment == null) {
                comment = "";
            }
            multiPart.field("comment", comment);
            multiPart.field("minorEdit", Boolean.toString(upload.isMinorEdit()));
            multiPart.field("hidden", Boolean.toString(upload.isHidden()));
        }
        return multiPart;
    }

    private BodyPart makeBodyPart(AttachmentUpload upload) {
        MediaType mediaType;
        if (upload.getName().contains("\"")) {
            throw new IllegalArgumentException("Double-quotes in filenames are not supported in the REST client");
        }
        String mediaTypeStr = upload.getMediaType();
        try {
            mediaType = MediaType.valueOf((String)mediaTypeStr);
        }
        catch (IllegalArgumentException e) {
            log.warn("Using 'text/plain' because type supplied is not a known media-type: " + mediaTypeStr);
            mediaType = MediaType.TEXT_PLAIN_TYPE;
        }
        try {
            return new StreamDataBodyPart("file", (InputStream)new FileInputStream(upload.getFile()), upload.getName(), mediaType);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("File " + upload.getFile() + " does not exist");
        }
    }

    public AttachmentService.Validator validator() {
        throw new UnsupportedOperationException("Remote validation is not supported by the client");
    }

    public class RemoteAttachmentFinderImpl
    extends AbstractRemoteService<AttachmentService.AttachmentFinder>
    implements RemoteAttachmentService.RemoteAttachmentFinder {
        private Expansion[] expansions;
        private ContentId attachmentId;
        private ContentId containerId;
        private String filename;
        private String mediaType;

        RemoteAttachmentFinderImpl(RemoteAttachmentServiceImpl otherService, Expansion[] expansions) {
            super(otherService);
            this.expansions = expansions;
        }

        @Override
        public RemoteContentService.RemoteSingleContentFetcher withId(ContentId attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        @Override
        public RemoteAttachmentService.RemoteAttachmentFinder withContainerId(ContentId containerId) {
            this.containerId = containerId;
            return this;
        }

        @Override
        public RemoteAttachmentService.RemoteAttachmentFinder withFilename(String filename) {
            this.filename = filename;
            return this;
        }

        @Override
        public RemoteAttachmentService.RemoteAttachmentFinder withMediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        @Override
        public CompletionStage<PageResponse<Content>> fetchManyCompletionStage(PageRequest request) {
            WebResource webResource = RemoteAttachmentServiceImpl.this.newAttachmentWebResource(this.containerId);
            if (this.filename != null) {
                webResource = webResource.queryParam("filename", this.filename);
            }
            if (this.mediaType != null) {
                webResource = webResource.queryParam("mediaType", this.mediaType);
            }
            webResource = this.addExpansions(webResource, this.expansions);
            webResource = this.addPageRequest(webResource, request);
            return this.getCompletionStagePageResponseList(webResource, Content.class);
        }

        @Override
        @Deprecated
        public Promise<Option<Content>> fetchOne() {
            return PromiseUtils.toPromiseOption(this.fetchCompletionStage(), this.getExecutor());
        }

        @Override
        public CompletionStage<Optional<Content>> fetchCompletionStage() {
            if (this.attachmentId != null) {
                return RemoteAttachmentServiceImpl.this.remoteContentService.find(this.expansions).withId(this.attachmentId).fetchCompletionStage();
            }
            return this.fetchManyCompletionStage(SimplePageRequest.ONE).thenApplyAsync(input -> {
                if (input.size() > 0) {
                    return Optional.of((Content)input.iterator().next());
                }
                return Optional.empty();
            }, this.getExecutor());
        }

        @Override
        @Deprecated
        public Promise<Content> fetchOneOrNull() {
            return PromiseUtils.toPromise(this.fetchOrNullCompletionStage());
        }

        @Override
        public CompletionStage<Content> fetchOrNullCompletionStage() {
            return this.fetchCompletionStage().thenApplyAsync(opt -> opt.orElse(null), this.getExecutor());
        }
    }
}

