/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.SpaceStatus;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteSpaceService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.util.PromiseUtils;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RemoteSpaceServiceImpl
extends AbstractRemoteService<SpaceService>
implements RemoteSpaceService {
    public static final String SPACE_RESOURCE_PATH = "space";
    public static final String PRIVATE_SPACE_SUBPATH = "_private";

    public RemoteSpaceServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    @Deprecated
    public Promise<Space> create(Space newSpace, boolean isPrivate) throws ServiceException {
        WebResource resource = this.newSpacesRestResource();
        if (isPrivate) {
            resource = resource.path(PRIVATE_SPACE_SUBPATH);
        }
        return this.postFuture(resource, Space.class, newSpace);
    }

    @Override
    @Deprecated
    public Promise<Space> update(Space space) throws ServiceException {
        WebResource resource = this.newSpacesRestResource(space);
        return this.putFuture(resource, Space.class, space);
    }

    @Override
    public CompletionStage<Space> createCompletionStage(Space newSpace, boolean isPrivate) throws ServiceException {
        WebResource resource = this.newSpacesRestResource();
        if (isPrivate) {
            resource = resource.path(PRIVATE_SPACE_SUBPATH);
        }
        return this.postCompletionStage(resource, Space.class, newSpace);
    }

    @Override
    public CompletionStage<Space> updateCompletionStage(Space space) throws ServiceException {
        WebResource resource = this.newSpacesRestResource(space);
        return this.putCompletionStage(resource, Space.class, space);
    }

    @Override
    public SpaceService.Validator validator() {
        throw new NotImplementedServiceException("SpaceService.validator() not yet supported");
    }

    @Override
    @Deprecated
    public Promise<Option<Space>> getSpace(String spaceKey, Expansion ... expansions) {
        throw new UnsupportedOperationException("Use find().withKeys(spaceKey).fetchOne() instead.");
    }

    @Override
    public RemoteSpaceService.RemoteSpaceFinder find(Expansion ... expansions) {
        return new RemoteSpaceFinderImpl(this, expansions);
    }

    @Override
    public RemoteSpaceService.RemoteSpaceContentFinder findContent(Space space, Expansion ... expansion) {
        return new RemoteSpaceContentFinderImpl(this, space, expansion);
    }

    @Override
    @Deprecated
    public Promise<LongTaskSubmission> delete(Space space) {
        WebResource resource = this.newSpacesRestResource(space);
        return this.deleteFuture(resource, LongTaskSubmission.class);
    }

    @Override
    public CompletionStage<LongTaskSubmission> deleteCompletionStage(Space space) {
        WebResource resource = this.newSpacesRestResource(space);
        return this.deleteCompletionStage(resource, LongTaskSubmission.class);
    }

    private WebResource newSpacesRestResource() {
        return this.newRestWebResource().path(SPACE_RESOURCE_PATH);
    }

    private WebResource newSpacesRestResource(Space space) {
        return this.newSpacesRestResource(space.getKey());
    }

    private WebResource newSpacesRestResource(String spaceKey) {
        return this.newSpacesRestResource().path(spaceKey);
    }

    public class RemoteSpaceContentFinderImpl
    extends AbstractRemoteService<SpaceService.SpaceContentFinder>
    implements RemoteSpaceService.RemoteSpaceContentFinder {
        WebResource resource;
        private Depth depth;

        public RemoteSpaceContentFinderImpl(AbstractRemoteService other, Space space, Expansion[] expansion) {
            super(other);
            this.depth = Depth.ALL;
            this.resource = RemoteSpaceServiceImpl.this.newSpacesRestResource(space).path("content");
            this.resource = this.addExpansions(this.resource, expansion);
        }

        @Override
        @Deprecated
        public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByType(PageRequest request) {
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams(this.resource);
            return this.getFutureMapOfPageResponses(this.resource, ContentType.class, Content.class);
        }

        @Override
        public CompletionStage<Map<ContentType, PageResponse<Content>>> fetchMappedByTypeCompletionStage(PageRequest request) {
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams(this.resource);
            return this.getCompletionStageMapOfPageResponses(this.resource, ContentType.class, Content.class);
        }

        @Override
        @Deprecated
        public Promise<PageResponse<Content>> fetchMany(ContentType type, PageRequest request) {
            this.resource = this.addPageRequestParams(this.resource.path(type.getType().toLowerCase()), request);
            this.resource = this.addParams(this.resource);
            return this.getFuturePageResponseList(this.resource, Content.class);
        }

        @Override
        public CompletionStage<PageResponse<Content>> fetchManyCompletionStage(ContentType type, PageRequest request) {
            this.resource = this.addPageRequestParams(this.resource.path(type.getType().toLowerCase()), request);
            this.resource = this.addParams(this.resource);
            return this.getCompletionStagePageResponseList(this.resource, Content.class);
        }

        @Override
        public RemoteSpaceService.RemoteSpaceContentFinder withDepth(Depth depth) {
            this.depth = depth;
            return this;
        }

        private WebResource addParams(WebResource resource) {
            return resource.queryParam("depth", this.depth.toString());
        }
    }

    public class RemoteSpaceFinderImpl
    extends AbstractRemoteService<SpaceService.SpaceFinder>
    implements RemoteSpaceService.RemoteSpaceFinder {
        private List<String> keys;
        private SpaceType spaceType;
        private SpaceStatus spaceStatus;
        private List<Label> labels;
        private final Expansion[] expansions;
        private @Nullable Boolean favourite;
        private @Nullable Boolean hasRetentionPolicy;

        protected RemoteSpaceFinderImpl(AbstractRemoteService other, Expansion ... expansions) {
            super(other);
            this.keys = new ArrayList<String>();
            this.labels = new ArrayList<Label>();
            this.favourite = null;
            this.hasRetentionPolicy = null;
            this.expansions = expansions;
        }

        @Override
        public RemoteSpaceService.RemoteSpaceFinder withKeys(String ... keys) {
            this.keys = Collections.unmodifiableList(Arrays.asList(keys));
            return this;
        }

        @Override
        public RemoteSpaceService.RemoteSpaceFinder withType(SpaceType type) {
            this.spaceType = type;
            return this;
        }

        @Override
        public RemoteSpaceService.RemoteSpaceFinder withStatus(SpaceStatus status) {
            this.spaceStatus = status;
            return this;
        }

        @Override
        public RemoteSpaceService.RemoteSpaceFinder withLabels(Label ... labels) {
            this.labels = Collections.unmodifiableList(Arrays.asList(labels));
            return this;
        }

        @Override
        public RemoteSpaceService.RemoteSpaceFinder withIsFavourited(boolean favourite) {
            this.favourite = favourite;
            return this;
        }

        @Override
        public RemoteSpaceService.RemoteSpaceFinder withHasRetentionPolicy(boolean hasRetentionPolicy) {
            this.hasRetentionPolicy = hasRetentionPolicy;
            return this;
        }

        @Override
        @Deprecated
        public Promise<PageResponse<Space>> fetchMany(PageRequest request) {
            WebResource webResource = this.addExpansions(RemoteSpaceServiceImpl.this.newSpacesRestResource(), this.expansions);
            webResource = this.addPageRequestParams(webResource, request);
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.put((Object)"spaceKey", this.keys);
            if (this.spaceType != null) {
                params.putSingle((Object)"type", (Object)this.spaceType.getType());
            }
            if (this.spaceStatus != null) {
                params.putSingle((Object)"status", (Object)this.spaceStatus.getValue());
            }
            if (this.labels != null && !this.labels.isEmpty()) {
                params.put((Object)"label", this.labels.stream().map(Label::getLabel).collect(Collectors.toList()));
            }
            if (this.favourite != null) {
                params.putSingle((Object)"favourite", (Object)this.favourite.toString());
            }
            if (this.hasRetentionPolicy != null) {
                params.putSingle((Object)"hasRetentionPolicy", (Object)this.hasRetentionPolicy.toString());
            }
            webResource = webResource.queryParams((MultivaluedMap)params);
            return this.getFuturePageResponseList(webResource, Space.class);
        }

        @Override
        public CompletionStage<PageResponse<Space>> fetchManyCompletionStage(PageRequest request) {
            WebResource webResource = this.addExpansions(RemoteSpaceServiceImpl.this.newSpacesRestResource(), this.expansions);
            webResource = this.addPageRequestParams(webResource, request);
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.put((Object)"spaceKey", this.keys);
            if (this.spaceType != null) {
                params.putSingle((Object)"type", (Object)this.spaceType.getType());
            }
            if (this.spaceStatus != null) {
                params.putSingle((Object)"status", (Object)this.spaceStatus.getValue());
            }
            if (this.labels != null && !this.labels.isEmpty()) {
                params.put((Object)"label", this.labels.stream().map(Label::getLabel).collect(Collectors.toList()));
            }
            if (this.favourite != null) {
                params.putSingle((Object)"favourite", (Object)this.favourite.toString());
            }
            if (this.hasRetentionPolicy != null) {
                params.putSingle((Object)"hasRetentionPolicy", (Object)this.hasRetentionPolicy.toString());
            }
            webResource = webResource.queryParams((MultivaluedMap)params);
            return this.getCompletionStagePageResponseList(webResource, Space.class);
        }

        @Override
        @Deprecated
        public Promise<Option<Space>> fetchOne() {
            return PromiseUtils.toPromiseOption(this.fetchCompletionStage(), this.getExecutor());
        }

        @Override
        @Deprecated
        public Promise<Space> fetchOneOrNull() {
            return PromiseUtils.toPromise(this.fetchOrNullCompletionStage());
        }

        @Override
        public CompletionStage<Optional<Space>> fetchCompletionStage() {
            if (this.keys.size() == 1) {
                WebResource resource = this.addExpansions(RemoteSpaceServiceImpl.this.newSpacesRestResource(this.keys.get(0)), this.expansions);
                return this.getCompletionStageOptional(resource, Space.class);
            }
            return this.fetchManyCompletionStage(SimplePageRequest.ONE).thenApplyAsync(input -> {
                if (input.size() > 0) {
                    return Optional.of((Space)input.iterator().next());
                }
                return Optional.empty();
            }, this.getExecutor());
        }

        @Override
        public CompletionStage<Space> fetchOrNullCompletionStage() {
            return this.fetchCompletionStage().thenApplyAsync(opt -> opt.orElse(null), this.getExecutor());
        }
    }
}

