/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.MacroInstance;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentMacroService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentMacroService;
import com.atlassian.confluence.rest.client.RemoteContentServiceImpl;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public class RemoteContentMacroServiceImpl
extends AbstractRemoteService<ContentMacroService>
implements RemoteContentMacroService {
    private RemoteContentServiceImpl contentService;

    public RemoteContentMacroServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
        this.contentService = new RemoteContentServiceImpl(provider, executor);
    }

    @Override
    public RemoteContentMacroService.RemoteMacroFinder findInContent(ContentId content, Expansion ... expansions) {
        return new RemoteMacroFinderImpl(this, content);
    }

    public class RemoteMacroFinderImpl
    extends AbstractRemoteService<ContentMacroService.MacroInstanceFinder>
    implements RemoteContentMacroService.RemoteMacroFinder {
        private final ContentId contentId;
        private String macroId;
        private int versionNumber;

        protected RemoteMacroFinderImpl(AbstractRemoteService otherService, ContentId contentId) {
            super(otherService);
            this.contentId = contentId;
        }

        @Override
        @Deprecated
        public RemoteContentMacroService.RemoteMacroFinder withHash(String hash) {
            this.macroId = hash;
            return this;
        }

        @Override
        public RemoteContentMacroService.RemoteMacroFinder withMacroId(String macroId) {
            this.macroId = macroId;
            return this;
        }

        @Override
        public RemoteContentMacroService.RemoteMacroFinder withContentVersion(int versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        @Deprecated
        public Promise<Optional<MacroInstance>> fetch() {
            WebResource resource = RemoteContentMacroServiceImpl.this.contentService.newContentWebResource().path(this.contentId.serialise()).path("history").path(Integer.toString(this.versionNumber)).path("macro").path("id").path(this.macroId);
            return this.getFutureOptional(resource, MacroInstance.class);
        }

        @Override
        public Promise<MacroInstance> fetchOneOrNull() {
            return this.fetchOne().map(Option::getOrNull);
        }

        @Override
        public CompletionStage<Optional<MacroInstance>> fetchCompletionStage() {
            WebResource resource = RemoteContentMacroServiceImpl.this.contentService.newContentWebResource().path(this.contentId.serialise()).path("history").path(Integer.toString(this.versionNumber)).path("macro").path("id").path(this.macroId);
            return this.getCompletionStageOptional(resource, MacroInstance.class);
        }

        @Override
        public CompletionStage<MacroInstance> fetchOrNullCompletionStage() {
            return this.fetchCompletionStage().thenApplyAsync(opt -> opt.orElse(null), this.getExecutor());
        }
    }
}

