/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.remoteservice.people;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.people.GroupService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.remoteservice.people.RemoteGroupService;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.ArrayUtils;

public class RemoteGroupServiceImpl
extends AbstractRemoteService<GroupService>
implements RemoteGroupService {
    public RemoteGroupServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public GroupService.Validator validator() {
        throw new NotImplementedServiceException("Remote validation is not supported");
    }

    @Override
    public RemoteGroupService.RemoteGroupFinder find(Expansion ... expansions) {
        return new RemoteGroupFinderImpl(expansions);
    }

    @Override
    public CompletionStage<Group> createGroup(String groupName) {
        String path = "/admin/group";
        WebResource resource = this.newRestWebResource().path("/admin/group");
        return this.postCompletionStage(resource, Group.class, new Group(groupName));
    }

    @Override
    public CompletionStage<Void> deleteGroup(String groupName) {
        String path = "/admin/group/" + groupName;
        WebResource resource = this.newRestWebResource().path(path);
        return this.deleteCompletionStage(resource, Void.class);
    }

    private WebResource newGroupResource() {
        return this.newRestWebResource().path("/group");
    }

    public class RemoteGroupFinderImpl
    extends AbstractRemoteService<GroupService.GroupFinder>
    implements RemoteGroupService.RemoteGroupFinder {
        private final Expansion[] expansions;
        private String groupName;
        private User member;

        public RemoteGroupFinderImpl(Expansion[] expansions) {
            super(RemoteGroupServiceImpl.this);
            this.expansions = (Expansion[])ArrayUtils.clone((Object[])expansions);
        }

        @Override
        public RemoteGroupService.RemoteGroupFinder withName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        @Override
        public RemoteGroupService.RemoteGroupFinder withMember(User user) {
            this.member = user;
            return this;
        }

        @Override
        @Deprecated
        public Promise<PageResponse<Group>> fetchMany(PageRequest request) {
            WebResource resource;
            if (this.member != null) {
                resource = this.newUserResource().path("/memberof");
                resource = this.member.optionalUserKey().isPresent() ? resource.queryParam("key", ((UserKey)this.member.optionalUserKey().get()).getStringValue()) : resource.queryParam("username", this.member.getUsername());
            } else {
                if (this.groupName != null && !this.groupName.isEmpty()) {
                    throw new IllegalStateException("Cannot fetch many when specifying a groupName");
                }
                resource = RemoteGroupServiceImpl.this.newGroupResource();
            }
            resource = this.addExpansions(resource, this.expansions);
            resource = this.addPageRequest(resource, request);
            return this.getFuturePageResponseList(resource, Group.class);
        }

        @Override
        public CompletionStage<PageResponse<Group>> fetchManyCompletionStage(PageRequest request) {
            WebResource resource;
            if (this.member != null) {
                resource = this.newUserResource().path("/memberof");
                resource = this.member.optionalUserKey().isPresent() ? resource.queryParam("key", ((UserKey)this.member.optionalUserKey().get()).getStringValue()) : resource.queryParam("username", this.member.getUsername());
            } else {
                if (this.groupName != null && !this.groupName.isEmpty()) {
                    throw new IllegalStateException("Cannot fetch many when specifying a groupName");
                }
                resource = RemoteGroupServiceImpl.this.newGroupResource();
            }
            resource = this.addExpansions(resource, this.expansions);
            resource = this.addPageRequest(resource, request);
            return this.getCompletionStagePageResponseList(resource, Group.class);
        }

        @Override
        @Deprecated
        public Promise<Optional<Group>> fetch() {
            if (this.groupName == null || this.groupName.isEmpty()) {
                throw new IllegalStateException("Must specify groupName when fetching one");
            }
            WebResource resource = RemoteGroupServiceImpl.this.newGroupResource().path(this.groupName);
            resource = this.addExpansions(resource, this.expansions);
            return this.getFutureOptional(resource, Group.class);
        }

        @Override
        public CompletionStage<Optional<Group>> fetchCompletionStage() {
            if (this.groupName == null || this.groupName.isEmpty()) {
                throw new IllegalStateException("Must specify groupName when fetching one");
            }
            WebResource resource = RemoteGroupServiceImpl.this.newGroupResource().path(this.groupName);
            resource = this.addExpansions(resource, this.expansions);
            return this.getCompletionStageOptional(resource, Group.class);
        }

        @Override
        public Promise<Group> fetchOneOrNull() {
            return this.fetch().map(item -> item.orElse(null));
        }

        @Override
        public CompletionStage<Group> fetchOrNullCompletionStage() {
            return this.fetchCompletionStage().thenApplyAsync(opt -> opt.orElse(null), this.getExecutor());
        }

        private WebResource newUserResource() {
            return this.newRestWebResource().path("/user");
        }
    }
}

