/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.graphql;

import com.atlassian.annotations.Internal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
public class GraphQLUtils {
    public static String buildRequestString(String queryFieldName, String queryFragment, Map<String, Object> arguments) {
        return GraphQLUtils.buildRequestString(GraphQLUtils.buildQuery(queryFieldName, queryFragment, arguments));
    }

    public static String buildQuery(String queryFieldName, String queryFragment, Map<String, Object> arguments) {
        return String.join((CharSequence)"\n", "", "{", String.format("  %s%s %s", queryFieldName, GraphQLUtils.buildGraphQLFieldArgumentsString(arguments), queryFragment), "}");
    }

    public static String buildRequestString(String query) {
        String delimitedQuery = query.replace("\n", "\\n").replace("\"", "\\\"");
        return String.join((CharSequence)"\n", "", "{", String.format("  \"query\":\"%s\"", delimitedQuery), "}");
    }

    public static String buildGraphQLFieldArgumentsString(Map<String, Object> arguments) {
        if (arguments.size() == 0) {
            return "";
        }
        List argumentParts = arguments.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), GraphQLUtils.toArgumentValue(entry.getValue()))).collect(Collectors.toList());
        return "(" + String.join((CharSequence)", ", argumentParts) + ")";
    }

    private static String toArgumentValue(Object value) {
        if (value instanceof String) {
            return String.format("\"%s\"", value.toString().replace("\"", "\\"));
        }
        if (value instanceof List) {
            List list = ((List)value).stream().map(GraphQLUtils::toArgumentValue).collect(Collectors.toList());
            return String.format("[ %s ]", String.join((CharSequence)", ", list));
        }
        return value != null ? value.toString() : "null";
    }
}

