/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.remoteservice.people;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.people.GroupService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.client.remoteservice.people.RemoteGroupService;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import org.apache.commons.lang3.ArrayUtils;

public class RemoteGroupServiceImpl
extends AbstractRemoteService<GroupService>
implements RemoteGroupService {
    public RemoteGroupServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public GroupService.Validator validator() {
        throw new NotImplementedServiceException("Remote validation is not supported");
    }

    @Override
    public RemoteGroupService.RemoteGroupFinder find(Expansion ... expansions) {
        return new RemoteGroupFinderImpl(expansions);
    }

    public class RemoteGroupFinderImpl
    extends AbstractRemoteService<GroupService.GroupFinder>
    implements RemoteGroupService.RemoteGroupFinder {
        private final Expansion[] expansions;
        private String groupName;
        private User member;

        public RemoteGroupFinderImpl(Expansion[] expansions) {
            super(RemoteGroupServiceImpl.this);
            this.expansions = (Expansion[])ArrayUtils.clone((Object[])expansions);
        }

        @Override
        public RemoteGroupService.RemoteGroupFinder withName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        @Override
        public RemoteGroupService.RemoteGroupFinder withMember(User user) {
            this.member = user;
            return this;
        }

        @Override
        public Promise<PageResponse<Group>> fetchMany(PageRequest request) {
            WebResource resource;
            if (this.member != null) {
                resource = this.newUserResource().path("/memberof");
                resource = this.member.getUserKey().isDefined() ? resource.queryParam("key", ((UserKey)this.member.getUserKey().get()).getStringValue()) : resource.queryParam("username", this.member.getUsername());
            } else {
                Preconditions.checkState((boolean)Strings.isNullOrEmpty((String)this.groupName), (Object)"Cannot fetch many when specifying a groupName");
                resource = this.newGroupResource();
            }
            resource = this.addExpansions(resource, this.expansions);
            resource = this.addPageRequest(resource, request);
            return this.getFuturePageResponseList(resource, Group.class);
        }

        @Override
        public Promise<Option<Group>> fetchOne() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.groupName) ? 1 : 0) != 0, (Object)"Must specify groupName when fetching one");
            WebResource resource = this.newGroupResource().path(this.groupName);
            resource = this.addExpansions(resource, this.expansions);
            return this.getFutureOption(resource, Group.class);
        }

        @Override
        public Promise<Group> fetchOneOrNull() {
            return this.fetch().map(item -> item.orElse(null));
        }

        private WebResource newGroupResource() {
            return this.newRestWebResource().path("/group");
        }

        private WebResource newUserResource() {
            return this.newRestWebResource().path("/user");
        }
    }
}

