/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ContentLabelService;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.api.model.RestList;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentLabelService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.StringKeyStringValueIgnoreCaseMultivaluedMap;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;

public class RemoteContentLabelServiceImpl
extends AbstractRemoteService<ContentLabelService>
implements RemoteContentLabelService {
    public RemoteContentLabelServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    public Promise<PageResponse<Label>> getLabels(ContentId contentId, Collection<Label.Prefix> prefixes, PageRequest request) throws NotFoundException {
        List prefixStrings = prefixes.stream().map(Enum::name).collect(Collectors.toList());
        WebResource resource = this.newRestWebResource().path("content").path(contentId.serialise()).path("label");
        StringKeyStringValueIgnoreCaseMultivaluedMap params = new StringKeyStringValueIgnoreCaseMultivaluedMap();
        params.put((Object)"prefix", prefixStrings);
        resource = resource.queryParams((MultivaluedMap)params);
        resource = this.addPageRequestParams(resource, request);
        return this.getFuturePageResponseList(resource, Label.class);
    }

    public Promise<PageResponse<Label>> addLabels(ContentId contentId, Iterable<Label> labels) throws ServiceException {
        WebResource resource = this.newRestWebResource().path("content").path(contentId.serialise()).path("label");
        return this.postFuture(resource, RestList.class, Label.class, labels);
    }

    @Override
    @Deprecated
    public Promise<Void> removeLabel(ContentId contentId, String label) throws ServiceException {
        WebResource resource = this.newRestWebResource().path("content").path(contentId.serialise()).path("label").path(label);
        return this.deleteFuture(resource, Void.class);
    }

    @Override
    public Promise<Void> removeLabel(ContentId contentId, Label label) {
        WebResource resource = this.newRestWebResource().path("content").path(contentId.serialise()).path("label").path(label.getLabel());
        return this.deleteFuture(resource, Void.class);
    }

    public ContentLabelService.Validator validator() {
        throw new UnsupportedOperationException("Remote validation is not currently supported.");
    }
}

