/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.watch.ContentWatch;
import com.atlassian.confluence.api.model.watch.SpaceWatch;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.watch.WatchService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteWatchService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;

public class RemoteWatchServiceImpl
extends AbstractRemoteService<WatchService>
implements RemoteWatchService {
    public RemoteWatchServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public WatchService.Validator validator() {
        throw new NotImplementedServiceException("WatchService.validator() not supported");
    }

    @Override
    public Promise<SpaceWatch> watchSpace(UserKey userKey, String spaceKey) {
        return this.postFuture(this.userWatchResource(userKey).path("space").path(spaceKey), SpaceWatch.class, null);
    }

    @Override
    public Promise<Boolean> isWatchingSpace(UserKey userKey, String spaceKey) {
        return this.getFuture(this.userWatchResource(userKey).path("space").path(spaceKey), Map.class).map(item -> (Boolean)item.get("watching"));
    }

    @Override
    public Promise<Void> unwatchSpace(UserKey userKey, String spaceKey) {
        return this.deleteFuture(this.userWatchResource(userKey).path("space").path(spaceKey));
    }

    @Override
    public Promise<ContentWatch> watchContent(UserKey userKey, ContentId contentId) {
        return this.postFuture(this.userWatchResource(userKey).path("content").path(contentId.serialise()), ContentWatch.class, null);
    }

    @Override
    public Promise<Void> unwatchContent(UserKey userKey, ContentId contentId) {
        return this.deleteFuture(this.userWatchResource(userKey).path("content").path(contentId.serialise()));
    }

    @Override
    public Promise<Boolean> isWatchingContent(UserKey userKey, ContentId contentId) {
        return this.getFuture(this.userWatchResource(userKey).path("content").path(contentId.serialise()), Map.class).map(item -> (Boolean)item.get("watching"));
    }

    private WebResource userWatchResource(UserKey userKey) {
        return this.newRestWebResource().path("user").path("watch").queryParam("key", userKey.getStringValue());
    }
}

