/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.remoteservice.webfragment;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.web.WebItemView;
import com.atlassian.confluence.api.model.web.WebPanelView;
import com.atlassian.confluence.api.model.web.WebSectionView;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.web.WebView;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.remoteservice.webfragment.RemoteWebView;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class RemoteWebViewImpl
extends AbstractRemoteService<WebView>
implements RemoteWebView {
    private Option<ContentId> contentId = Option.none();
    private Option<String> spaceKey = Option.none();

    RemoteWebViewImpl(AbstractRemoteService delegate) {
        super(delegate);
    }

    void setContentId(ContentId contentId) {
        this.contentId = Option.option((Object)contentId);
    }

    void setSpaceKey(String spaceKey) {
        this.spaceKey = Option.option((Object)spaceKey);
    }

    @Override
    public Promise<Iterable<WebItemView>> getItemsForSection(String section, Map<String, Object> additionalContext) {
        throw new NotImplementedServiceException("Items for section not yet implemented in client");
    }

    @Override
    public Promise<Iterable<WebSectionView>> getSectionsForLocation(String location, Map<String, Object> additionalContext) {
        WebResource webResource = this.addContextParams(this.newWebFragmentResource().path("section").path(location), additionalContext);
        return this.getFutureGenericCollection(webResource, ArrayList.class, WebSectionView.class);
    }

    @Override
    public Promise<Iterable<WebSectionView>> getSectionsForLocations(Collection<String> locations, Map<String, Object> additionalContext) {
        WebResource webResource = this.newWebFragmentResource().path("section");
        for (String location : locations) {
            webResource = webResource.queryParam("location", location);
        }
        webResource = this.addContextParams(webResource, additionalContext);
        return this.getFutureGenericCollection(webResource, ArrayList.class, WebSectionView.class);
    }

    @Override
    public Promise<Iterable<WebPanelView>> getPanelsForLocation(String location, Map<String, Object> additionalContext) {
        WebResource webResource = this.addContextParams(this.newWebFragmentResource().path("panels").path(location), additionalContext);
        return this.getFutureGenericCollection(webResource, ArrayList.class, WebPanelView.class);
    }

    @Override
    public Promise<Iterable<WebPanelView>> getPanelsForLocations(Collection<String> locations, Map<String, Object> additionalContext) {
        WebResource webResource = this.newWebFragmentResource().path("panels");
        for (String location : locations) {
            webResource = webResource.queryParam("location", location);
        }
        webResource = this.addContextParams(webResource, additionalContext);
        return this.getFutureGenericCollection(webResource, ArrayList.class, WebPanelView.class);
    }

    private WebResource addContextParams(WebResource resource, Map<String, Object> additionalContext) {
        if (this.contentId.isDefined()) {
            resource = resource.queryParam("contentId", ((ContentId)this.contentId.get()).serialise());
        }
        if (this.spaceKey.isDefined()) {
            resource = resource.queryParam("spaceKey", (String)this.spaceKey.get());
        }
        return resource;
    }

    private WebResource newWebFragmentResource() {
        return this.newExperimentalRestWebResource().path("webfragment");
    }
}

