/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.content.id.JsonContentPropertyId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentPropertyService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class RemoteContentPropertyServiceImpl
extends AbstractRemoteService<ContentPropertyService>
implements RemoteContentPropertyService {
    public RemoteContentPropertyServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public RemoteContentPropertyService.RemoteContentPropertyFinder find(Expansion ... expansions) {
        return new RemoteContentPropertyFinderImpl(this, expansions);
    }

    @Override
    public Promise<JsonContentProperty> create(JsonContentProperty newProperty) {
        WebResource resource = this.getContentPropertyWebResource(newProperty);
        return this.postFuture(resource, JsonContentProperty.class, newProperty);
    }

    @Override
    public Promise<JsonContentProperty> update(JsonContentProperty property) {
        WebResource resource = this.getContentPropertyWebResource(property).path(property.getKey());
        return this.putFuture(resource, JsonContentProperty.class, property);
    }

    @Override
    public Promise<Void> delete(JsonContentProperty property) {
        WebResource resource = this.getContentPropertyWebResource(property).path(property.getKey());
        return this.deleteFuture(resource);
    }

    @Override
    public RemoteContentPropertyService.RemoteValidator validator() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private WebResource getContentPropertyWebResource(JsonContentProperty property) {
        return this.getContentPropertyWebResource(this.getContentId(property));
    }

    private WebResource getContentPropertyWebResource(ContentId contentId) {
        return this.newRestWebResource().path("content").path(contentId.serialise()).path("property");
    }

    private ContentId getContentId(JsonContentProperty property) {
        return Content.getSelector((Reference)property.getContentRef()).getId();
    }

    public class RemoteContentPropertyFinderImpl
    extends AbstractRemoteService<ContentPropertyService.ContentPropertyFinder>
    implements RemoteContentPropertyService.RemoteContentPropertyFinder {
        private final Expansion[] expansions;
        private ContentId contentId;
        private JsonContentPropertyId contentPropertyId;
        private String key;

        public RemoteContentPropertyFinderImpl(AbstractRemoteService other, Expansion ... expansions) {
            super(other);
            this.expansions = expansions;
        }

        @Override
        public RemoteContentPropertyService.RemoteSingleContentPropertyFetcher withId(JsonContentPropertyId contentPropertyId) {
            this.contentPropertyId = contentPropertyId;
            return this;
        }

        @Override
        public RemoteContentPropertyService.RemoteParameterContentPropertyFinder withContentId(ContentId contentId) {
            this.contentId = contentId;
            return this;
        }

        @Override
        public RemoteContentPropertyService.RemoteParameterContentPropertyFinder withContentIds(List<ContentId> contentIds) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public RemoteContentPropertyService.RemoteParameterContentPropertyFinder withPropertyKeys(List<String> keys) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public RemoteContentPropertyService.RemoteParameterContentPropertyFinder withKey(String key) {
            return this.withPropertyKey(key);
        }

        @Override
        public RemoteContentPropertyService.RemoteParameterContentPropertyFinder withPropertyKey(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Promise<PageResponse<JsonContentProperty>> fetchMany(PageRequest request) {
            WebResource resource = RemoteContentPropertyServiceImpl.this.getContentPropertyWebResource(this.contentId);
            resource = this.addExpansions(resource, this.expansions);
            resource = this.addPageRequest(resource, request);
            return this.getFuturePageResponseList(resource, JsonContentProperty.class);
        }

        @Override
        public Promise<Option<JsonContentProperty>> fetchOne() {
            if (this.contentPropertyId != null) {
                throw new UnsupportedOperationException("remote fetch with contentPropertyId is not supported");
            }
            Preconditions.checkNotNull((Object)this.contentId, (Object)"ContentId is required to locate content properties");
            WebResource resource = RemoteContentPropertyServiceImpl.this.getContentPropertyWebResource(this.contentId);
            if (this.key != null) {
                resource = resource.path(this.key);
            }
            resource = this.addExpansions(resource, this.expansions);
            return this.getFutureOption(resource, JsonContentProperty.class);
        }

        @Override
        public Promise<JsonContentProperty> fetchOneOrNull() {
            return this.fetchOne().map(Option::getOrNull);
        }
    }
}

