/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.service.content.ContentVersionService;
import com.atlassian.confluence.api.service.content.VersionRestoreParameters;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentVersionService;
import com.atlassian.confluence.rest.client.RemoteSingleFetcher;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.confluence.rest.serialization.RestData;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;

public class RemoteContentVersionServiceImpl
extends AbstractRemoteService<ContentVersionService>
implements RemoteContentVersionService {
    public static final String VERSION = "version";

    public RemoteContentVersionServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executorService) {
        super(provider, executorService);
    }

    @Override
    public RemoteContentVersionService.RemoteVersionFinder find(Expansion ... expansions) {
        return new RemoteVersionFinderImpl(this, expansions);
    }

    @Override
    public Promise<Void> delete(ContentId contentId, int versionNumber) {
        WebResource webResource = this.getWebResource(contentId).path(String.valueOf(versionNumber));
        return this.deleteFuture(webResource);
    }

    @Override
    public Promise<Version> restore(ContentId contentId, VersionRestoreParameters versionRestoreParameters, Expansion ... expansions) {
        WebResource webResource = this.getWebResource(contentId);
        webResource = this.addExpansions(webResource, expansions);
        RestData restData = RestData.builder().operation(OperationKey.RESTORE).params(versionRestoreParameters.toMap()).build();
        return this.postFuture(webResource, Version.class, restData);
    }

    private WebResource getWebResource(ContentId contentId) {
        return this.newExperimentalRestWebResource().path("content").path(contentId.serialise()).path(VERSION);
    }

    public class RemoteVersionFinderImpl
    extends AbstractRemoteService<ContentVersionService.VersionFinder>
    implements RemoteContentVersionService.RemoteVersionFinder {
        private final Expansion[] expansions;
        private ContentId contentId;
        private int version;

        RemoteVersionFinderImpl(RemoteContentVersionServiceImpl service, Expansion ... expansions) {
            super(service);
            this.expansions = expansions;
        }

        @Override
        public RemoteSingleFetcher withIdAndVersion(ContentId contentId, int version) {
            this.contentId = contentId;
            this.version = version;
            return this;
        }

        @Override
        public Promise<PageResponse<Version>> fetchMany(PageRequest pageRequest) {
            WebResource webResource = RemoteContentVersionServiceImpl.this.getWebResource(this.contentId);
            webResource = this.addPageRequest(webResource, pageRequest);
            webResource = this.addExpansions(webResource, this.expansions);
            return this.getFuturePageResponseList(webResource, Version.class);
        }

        @Override
        public RemoteContentVersionService.RemoteParameterVersionFinder withId(ContentId contentId) {
            this.contentId = contentId;
            return this;
        }

        @Override
        public Promise<Option<Version>> fetchOne() {
            WebResource webResource = RemoteContentVersionServiceImpl.this.getWebResource(this.contentId).path(String.valueOf(this.version));
            return this.getFutureOption(webResource, Version.class);
        }

        @Override
        public Promise<Version> fetchOneOrNull() {
            return this.fetchOne().map(Option::getOrNull);
        }
    }
}

