/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.graphql;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

@Internal
public class GraphQLQueryResponse<T> {
    @JsonProperty
    private T data;
    @JsonProperty
    private List<Map<String, Object>> errors;

    public T getData() {
        return this.data;
    }

    public List<Map<String, Object>> getErrors() {
        return this.errors;
    }

    public void throwFirstErrorIfExists() {
        this.throwFirstErrorIfExists(this.getErrors());
    }

    private void throwFirstErrorIfExists(Object obj) {
        List list;
        if (obj == null) {
            return;
        }
        if (obj instanceof String) {
            throw new ServiceException((String)obj);
        }
        if (obj instanceof List && !(list = (List)obj).isEmpty()) {
            this.throwFirstErrorIfExists(list.get(0));
        }
        if (obj instanceof Map) {
            this.throwFirstErrorIfExists((Map)obj);
        }
    }

    private void throwFirstErrorIfExists(Map<String, Object> map) {
        String message;
        if (map == null) {
            return;
        }
        Integer statusCode = (Integer)map.get("statusCode");
        if (statusCode != null) {
            if (statusCode.equals(400)) {
                throw new BadRequestException(GraphQLQueryResponse.getErrorMessage(map));
            }
            if (statusCode.equals(404)) {
                throw new NotFoundException(GraphQLQueryResponse.getErrorMessage(map));
            }
            if (statusCode.equals(403)) {
                throw new PermissionException(GraphQLQueryResponse.getErrorMessage(map));
            }
        }
        if (!Strings.isNullOrEmpty((String)(message = GraphQLQueryResponse.getErrorMessage(map)))) {
            throw new ServiceException(message);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.throwFirstErrorIfExists(entry.getValue());
        }
        throw new ServiceException("An unknown error occurred");
    }

    private static String getErrorMessage(Map<String, Object> map) {
        if (map.containsKey("message")) {
            return (String)map.get("message");
        }
        if (map.containsKey("translation")) {
            return (String)map.get("translation");
        }
        return "";
    }
}

