/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.remoteservice.webfragment.graphql;

import com.atlassian.confluence.api.model.web.WebItemView;
import com.atlassian.confluence.api.model.web.WebPanelView;
import com.atlassian.confluence.api.model.web.WebSectionView;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.graphql.GraphQLQueryResponse;
import com.atlassian.confluence.rest.client.graphql.GraphQLUtils;
import com.atlassian.confluence.rest.client.remoteservice.webfragment.AbstractRemoteWebView;
import com.atlassian.confluence.rest.client.remoteservice.webfragment.RemoteWebView;
import com.atlassian.util.concurrent.Promise;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.WebResource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GraphQLRemoteWebViewImpl
extends AbstractRemoteWebView
implements RemoteWebView {
    private static final String WEB_ITEM_FIELDS = "url\nlabel\nweight\nmoduleKey\nid\naccessKey\ncompleteKey\nsection\ntooltip\nstyleClass\nurlWithoutContextPath\nicon { path width height isDefault }\nparams { key value }\n";
    private static final String WEB_PANEL_FIELDS = "moduleKey\ncompleteKey\nhtml\nlocation\nlabel\nweight\nname\n";

    GraphQLRemoteWebViewImpl(AbstractRemoteService delegate) {
        super(delegate);
    }

    @Override
    public Promise<Iterable<WebItemView>> getItemsForSection(String section, Map<String, Object> additionalContext) {
        String[] parts = section.split("/");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("location", parts[0]);
        variables.put("section", parts[1]);
        variables.putAll(additionalContext);
        String query = "{\n  webItems" + GraphQLUtils.buildGraphQLFieldArgumentsString(variables) + " {\n" + WEB_ITEM_FIELDS + "  }}";
        String requestString = GraphQLUtils.buildRequestString(query);
        Promise<GraphQLWebItemsResponse> responsePromise = this.postFuture(this.newGraphWebResource(), GraphQLWebItemsResponse.class, requestString);
        return responsePromise.map(response -> {
            response.throwFirstErrorIfExists();
            List webItems = (List)((Map)response.getData()).get("webItems");
            if (webItems.isEmpty()) {
                throw new NotFoundException();
            }
            return webItems;
        });
    }

    @Override
    public Promise<Iterable<WebSectionView>> getSectionsForLocation(String location, Map<String, Object> additionalContext) {
        return this.getSectionsForLocations(Lists.newArrayList((Object[])new String[]{location}), additionalContext);
    }

    @Override
    public Promise<Iterable<WebSectionView>> getSectionsForLocations(Collection<String> locations, Map<String, Object> additionalContext) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("locations", locations);
        variables.putAll(additionalContext);
        String query = "{\n  webItemSections" + GraphQLUtils.buildGraphQLFieldArgumentsString(variables) + " {\n    id\n    label\n    styleClass\n    items {\n" + WEB_ITEM_FIELDS + "    }\n  }\n}";
        String requestString = GraphQLUtils.buildRequestString(query);
        Promise<GraphQLWebSectionsResponse> responsePromise = this.postFuture(this.newGraphWebResource(), GraphQLWebSectionsResponse.class, requestString);
        return responsePromise.map(response -> {
            response.throwFirstErrorIfExists();
            List webItemSections = (List)((Map)response.getData()).get("webItemSections");
            if (webItemSections.isEmpty()) {
                throw new NotFoundException();
            }
            return webItemSections;
        });
    }

    @Override
    public Promise<Iterable<WebPanelView>> getPanelsForLocation(String location, Map<String, Object> additionalContext) {
        return this.getPanelsForLocations(Lists.newArrayList((Object[])new String[]{location}), additionalContext);
    }

    @Override
    public Promise<Iterable<WebPanelView>> getPanelsForLocations(Collection<String> locations, Map<String, Object> additionalContext) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("locations", locations);
        variables.putAll(additionalContext);
        String query = "{\n  webPanels" + GraphQLUtils.buildGraphQLFieldArgumentsString(variables) + " {\n" + WEB_PANEL_FIELDS + "  }\n}";
        String requestString = GraphQLUtils.buildRequestString(query);
        Promise<GraphQLWebPanelsResponse> responsePromise = this.postFuture(this.newGraphWebResource(), GraphQLWebPanelsResponse.class, requestString);
        return responsePromise.map(response -> {
            response.throwFirstErrorIfExists();
            List webItemSections = (List)((Map)response.getData()).get("webPanels");
            if (webItemSections.isEmpty()) {
                throw new NotFoundException();
            }
            return webItemSections;
        });
    }

    private WebResource newGraphWebResource() {
        return this.provider.newRestWebResource().path("rest").path("graph");
    }

    public static class GraphQLWebPanelsResponse
    extends GraphQLQueryResponse<Map<String, List<WebPanelView>>> {
    }

    public static class GraphQLWebSectionsResponse
    extends GraphQLQueryResponse<Map<String, List<WebSectionView>>> {
    }

    public static class GraphQLWebItemsResponse
    extends GraphQLQueryResponse<Map<String, List<WebItemView>>> {
    }
}

