/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ContentVersionService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentVersionService;
import com.atlassian.confluence.rest.client.RemoteSingleFetcher;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;

public class RemoteContentVersionServiceImpl
extends AbstractRemoteService<ContentVersionService>
implements RemoteContentVersionService {
    public RemoteContentVersionServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executorService) {
        super(provider, executorService);
    }

    @Override
    public RemoteContentVersionService.RemoteVersionFinder find(Expansion ... expansions) {
        return new RemoteVersionFinderImpl(this, expansions);
    }

    public class RemoteVersionFinderImpl
    extends AbstractRemoteService<ContentVersionService.VersionFinder>
    implements RemoteContentVersionService.RemoteVersionFinder {
        public static final String VERSION = "version";
        private final Expansion[] expansions;
        private ContentId contentId;
        private Version version;

        RemoteVersionFinderImpl(RemoteContentVersionServiceImpl service, Expansion ... expansions) {
            super(service);
            this.expansions = expansions;
        }

        private WebResource getWebResource() {
            return this.newExperimentalRestWebResource().path("content").path(this.contentId.serialise()).path(VERSION);
        }

        @Override
        public RemoteSingleFetcher withIdAndVersion(ContentId contentId, Version version) {
            this.contentId = contentId;
            this.version = version;
            return this;
        }

        @Override
        public Promise<PageResponse<Version>> fetchMany(PageRequest pageRequest) {
            WebResource webResource = this.getWebResource();
            webResource = this.addPageRequest(webResource, pageRequest);
            webResource = this.addExpansions(webResource, this.expansions);
            return this.getFuturePageResponseList(webResource, Version.class);
        }

        @Override
        public RemoteContentVersionService.RemoteParameterVersionFinder withId(ContentId contentId) {
            this.contentId = contentId;
            return this;
        }

        @Override
        public Promise<Option<Version>> fetchOne() {
            WebResource webResource = this.getWebResource().path(String.valueOf(this.version.getNumber()));
            return this.getFutureOption(webResource, Version.class);
        }

        @Override
        public Promise<Version> fetchOneOrNull() {
            return this.fetchOne().map(Option::getOrNull);
        }
    }
}

