/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.ContentRestrictionsPageResponse;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.permissions.ContentRestrictionService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentRestrictionService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class RemoteContentRestrictionServiceImpl
extends AbstractRemoteService<ContentRestrictionService>
implements RemoteContentRestrictionService {
    private static final String BY_OPERATION_SUBPATH = "byOperation";
    private static final String CONTENTID_CANNOT_BE_NULL = "\"contentId\" cannot be `null`. Please provide valid contentId.";
    private static final String CONTENT_RSTRICTIONS_CANNOT_BE_NULL = "\"contentRstrictions\" cannot be `null`. Please provide correct contentRestrictions.";

    public RemoteContentRestrictionServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public Promise<Map<OperationKey, ContentRestriction>> getRestrictionsGroupByOperation(ContentId target, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.newContentRestrictionsWebResource(target).path(BY_OPERATION_SUBPATH);
        resource = this.addExpansions(resource, expansions);
        return this.getFutureMap(resource, OperationKey.class, ContentRestriction.class);
    }

    @Override
    public Promise<ContentRestriction> getRestrictionsForOperation(ContentId target, OperationKey operationKey, PageRequest pageRequest, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.newContentRestrictionsWebResource(target).path(BY_OPERATION_SUBPATH).path(operationKey.toString());
        resource = this.addExpansions(resource, expansions);
        resource = this.addPageRequest(resource, pageRequest);
        return this.getFuture(resource, ContentRestriction.class);
    }

    @Override
    public Promise<ContentRestrictionsPageResponse> getRestrictions(ContentId target, PageRequest pageRequest, Expansion ... expansions) throws NotFoundException {
        WebResource resource = this.newContentRestrictionsExperimentalWebResource(target);
        resource = this.addExpansions(resource, expansions);
        resource = this.addPageRequest(resource, pageRequest);
        return this.getFuture(resource, ContentRestrictionsPageResponse.class);
    }

    @Override
    public Promise<ContentRestrictionsPageResponse> updateRestrictions(ContentId target, Collection<? extends ContentRestriction> contentRestrictions, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.addExpansions(this.newContentRestrictionsExperimentalWebResource(target), expansions);
        ContentRestrictionsPageResponse restrictions = ((ContentRestrictionsPageResponse.ContentRestrictionPageResponseBuilder)ContentRestrictionsPageResponse.builder().withContentId(Objects.requireNonNull(target, CONTENTID_CANNOT_BE_NULL)).addAll(Objects.requireNonNull(contentRestrictions, CONTENT_RSTRICTIONS_CANNOT_BE_NULL))).build();
        return this.putFuture(resource, ContentRestrictionsPageResponse.class, restrictions);
    }

    private WebResource newContentRestrictionsWebResource(ContentId contentId) {
        Objects.requireNonNull(contentId, CONTENTID_CANNOT_BE_NULL);
        return this.newRestWebResource().path("content").path(contentId.serialise()).path("restriction");
    }

    private WebResource newContentRestrictionsExperimentalWebResource(ContentId contentId) {
        Objects.requireNonNull(contentId, CONTENTID_CANNOT_BE_NULL);
        return this.newExperimentalRestWebResource().path("content").path(contentId.serialise()).path("restriction");
    }
}

