/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.template.ContentTemplate;
import com.atlassian.confluence.api.model.content.template.ContentTemplateId;
import com.atlassian.confluence.api.model.content.template.ContentTemplateType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.template.ContentTemplateService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentTemplateService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;

public class RemoteContentTemplateServiceImpl
extends AbstractRemoteService<ContentTemplateService>
implements RemoteContentTemplateService {
    private final ContentTemplateType templateType;

    public RemoteContentTemplateServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executorService, ContentTemplateType templateType) {
        super(provider, executorService);
        this.templateType = templateType;
    }

    @Override
    public Promise<PageResponse<ContentTemplate>> getTemplates(Option<Space> space, PageRequest pageRequest, Expansion ... expansions) {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path(this.templateType.getType());
        if (space.isDefined()) {
            webResource = webResource.queryParam("spaceKey", ((Space)space.get()).getKey());
        }
        webResource = this.addPageRequest(webResource, pageRequest);
        this.addExpansions(webResource, expansions);
        return this.getFuturePageResponseList(webResource, ContentTemplate.class);
    }

    private WebResource getWebResource() {
        return this.newExperimentalRestWebResource().path("template");
    }

    @Override
    public Promise<ContentTemplate> getTemplate(ContentTemplateId contentTemplateId, Expansion ... expansions) {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path(contentTemplateId.serialise());
        this.addExpansions(webResource, expansions);
        return this.getFuture(webResource, ContentTemplate.class);
    }

    @Override
    public Promise<ContentTemplate> create(ContentTemplate contentTemplate, Expansion ... expansions) {
        WebResource resource = this.getWebResource();
        resource = this.addExpansions(resource, expansions);
        return this.postFuture(resource, ContentTemplate.class, contentTemplate);
    }

    @Override
    public Promise<ContentTemplate> update(ContentTemplate contentTemplate, Expansion ... expansions) {
        WebResource resource = this.getWebResource();
        resource = this.addExpansions(resource, expansions);
        return this.putFuture(resource, ContentTemplate.class, contentTemplate);
    }

    @Override
    public Promise<Void> delete(ContentTemplateId contentTemplateId) {
        WebResource resource = this.getWebResource();
        resource = resource.path(contentTemplateId.serialise());
        return this.deleteFuture(resource);
    }

    @Override
    public RemoteContentTemplateService.RemoteTemplateFinder find(Expansion ... expansions) {
        return new RemoteTemplateFinderImpl(this, expansions);
    }

    public class RemoteTemplateFinderImpl
    extends AbstractRemoteService<ContentTemplateService.TemplateFinder>
    implements RemoteContentTemplateService.RemoteTemplateFinder {
        private final Expansion[] expansions;
        private ContentTemplateId contentTemplateId;
        private Option<Space> space;

        RemoteTemplateFinderImpl(RemoteContentTemplateServiceImpl service, Expansion ... expansions) {
            super(service);
            this.space = Option.none();
            this.expansions = expansions;
        }

        @Override
        public RemoteContentTemplateService.RemoteSingleTemplateFetcher withId(ContentTemplateId contentTemplateId) {
            this.contentTemplateId = contentTemplateId;
            return this;
        }

        @Override
        public RemoteContentTemplateService.RemoteParameterTemplateFinder withSpace(Space space) {
            if (space != null) {
                this.space = Option.some((Object)space);
            }
            return this;
        }

        @Override
        public Promise<PageResponse<ContentTemplate>> fetchMany(PageRequest request) {
            WebResource webResource = RemoteContentTemplateServiceImpl.this.getWebResource().path(RemoteContentTemplateServiceImpl.this.templateType.getType());
            if (this.space.isDefined()) {
                webResource = webResource.queryParam("spaceKey", ((Space)this.space.get()).getKey());
            }
            webResource = this.addPageRequest(webResource, request);
            webResource = this.addExpansions(webResource, this.expansions);
            return this.getFuturePageResponseList(webResource, ContentTemplate.class);
        }

        @Override
        public Promise<Option<ContentTemplate>> fetchOne() {
            if (this.contentTemplateId != null) {
                WebResource webResource = RemoteContentTemplateServiceImpl.this.getWebResource().path(this.contentTemplateId.serialise());
                webResource = this.addExpansions(webResource, this.expansions);
                return this.getFutureOption(webResource, ContentTemplate.class);
            }
            return this.fetchMany(SimplePageRequest.ONE).map(input -> {
                if (input.size() > 0) {
                    return Option.some(input.iterator().next());
                }
                return Option.none();
            });
        }

        @Override
        public Promise<ContentTemplate> fetchOneOrNull() {
            return this.fetchOne().map(Option::getOrNull);
        }
    }
}

