/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.ContentRestrictionsPageResponse;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.permissions.ContentRestrictionService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentRestrictionService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;

public class RemoteContentRestrictionServiceImpl
extends AbstractRemoteService<ContentRestrictionService>
implements RemoteContentRestrictionService {
    private static final String BY_OPERATION_SUBPATH = "byOperation";
    private static final String USER_SUBPATH = "user";
    private static final String GROUP_SUBPATH = "group";
    private static final String CONTENTID_CANNOT_BE_NULL = "\"contentId\" cannot be `null`. Please provide valid contentId.";
    private static final String CONTENT_RSTRICTIONS_CANNOT_BE_NULL = "\"contentRstrictions\" cannot be `null`. Please provide correct contentRestrictions.";
    private static final String OPERATION_KEY_CANNOT_BE_NULL = "\"operationKey\" cannot be `null`. Please provide valid operationKey.";
    private static final String SUBJECT_CANNOT_BE_NULL = "\"subject\" cannot be `null`. Please provide valid User ot Group.";

    public RemoteContentRestrictionServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public Promise<Map<OperationKey, ContentRestriction>> getRestrictionsGroupByOperation(ContentId target, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.newContentRestrictionsWebResource(target).path(BY_OPERATION_SUBPATH);
        resource = this.addExpansions(resource, expansions);
        return this.getFutureMap(resource, OperationKey.class, ContentRestriction.class);
    }

    @Override
    public Promise<ContentRestriction> getRestrictionsForOperation(ContentId target, OperationKey operationKey, PageRequest pageRequest, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.newContentRestrictionsWebResource(target).path(BY_OPERATION_SUBPATH).path(operationKey.toString());
        resource = this.addExpansions(resource, expansions);
        resource = this.addPageRequest(resource, pageRequest);
        return this.getFuture(resource, ContentRestriction.class);
    }

    @Override
    public Promise<ContentRestrictionsPageResponse> getRestrictions(ContentId target, PageRequest pageRequest, Expansion ... expansions) throws NotFoundException {
        WebResource resource = this.newContentRestrictionsExperimentalWebResource(target);
        resource = this.addExpansions(resource, expansions);
        resource = this.addPageRequest(resource, pageRequest);
        return this.getFuture(resource, ContentRestrictionsPageResponse.class);
    }

    @Override
    public Promise<ContentRestrictionsPageResponse> updateRestrictions(ContentId target, Collection<? extends ContentRestriction> contentRestrictions, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.addExpansions(this.newContentRestrictionsExperimentalWebResource(target), expansions);
        ContentRestrictionsPageResponse restrictions = ((ContentRestrictionsPageResponse.ContentRestrictionPageResponseBuilder)ContentRestrictionsPageResponse.builder().withContentId(Objects.requireNonNull(target, CONTENTID_CANNOT_BE_NULL)).addAll(Objects.requireNonNull(contentRestrictions, CONTENT_RSTRICTIONS_CANNOT_BE_NULL))).build();
        return this.putFuture(resource, ContentRestrictionsPageResponse.class, restrictions);
    }

    @Override
    public Promise<ContentRestrictionsPageResponse> addRestrictions(ContentId target, Collection<? extends ContentRestriction> contentRestrictions, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.addExpansions(this.newContentRestrictionsExperimentalWebResource(target), expansions);
        ContentRestrictionsPageResponse restrictions = ((ContentRestrictionsPageResponse.ContentRestrictionPageResponseBuilder)ContentRestrictionsPageResponse.builder().withContentId(Objects.requireNonNull(target, CONTENTID_CANNOT_BE_NULL)).addAll(Objects.requireNonNull(contentRestrictions, CONTENT_RSTRICTIONS_CANNOT_BE_NULL))).build();
        return this.postFuture(resource, ContentRestrictionsPageResponse.class, restrictions);
    }

    @Override
    public Promise<ContentRestrictionsPageResponse> deleteRestrictions(ContentId target, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.addExpansions(this.newContentRestrictionsExperimentalWebResource(target), expansions);
        return this.deleteFuture(resource, ContentRestrictionsPageResponse.class);
    }

    @Override
    public Promise<Boolean> hasDirectRestrictionForSubject(ContentId contentId, OperationKey operationKey, Subject subject) throws ServiceException {
        Objects.requireNonNull(operationKey, OPERATION_KEY_CANNOT_BE_NULL);
        Objects.requireNonNull(subject, SUBJECT_CANNOT_BE_NULL);
        if (subject instanceof User) {
            return this.hasDirectRestrictionForUser(contentId, operationKey, (User)subject);
        }
        if (subject instanceof Group) {
            return this.hasDirectRestrictionForGroup(contentId, operationKey, (Group)subject);
        }
        throw new BadRequestException("Checking restrictions only supported for User(s) and Group(s), whereas <" + subject + "> was provided");
    }

    private Promise<Boolean> hasDirectRestrictionForUser(ContentId contentId, OperationKey operationKey, User user) throws ServiceException {
        if (user == null || !user.getUserKey().isDefined() && !user.getOptionalUsername().isDefined()) {
            throw new BadRequestException("Should provide user with a valid UserKey or userName");
        }
        WebResource resource = this.newContentRestrictionsExperimentalWebResource(contentId).path(BY_OPERATION_SUBPATH).path(operationKey.toString()).path(USER_SUBPATH);
        if (user.getUserKey().isDefined()) {
            resource = resource.queryParam("key", ((UserKey)user.getUserKey().get()).toString());
        }
        if (user.getOptionalUsername().isDefined()) {
            resource = resource.queryParam("userName", (String)user.getOptionalUsername().get());
        }
        Promise<ClientResponse> future = this.getFuture(resource, ClientResponse.class);
        return future.map(response -> response.getStatus() == Response.Status.OK.getStatusCode()).recover(ex -> {
            if (ex instanceof NotFoundException) {
                return false;
            }
            throw (RuntimeException)ex;
        });
    }

    private Promise<Boolean> hasDirectRestrictionForGroup(ContentId contentId, OperationKey operationKey, Group group) throws ServiceException {
        if (group.getName() == null) {
            throw new BadRequestException("Please provide group with non-`null` group name");
        }
        WebResource resource = this.newContentRestrictionsExperimentalWebResource(contentId).path(BY_OPERATION_SUBPATH).path(operationKey.toString()).path(GROUP_SUBPATH).path(group.getName());
        Promise<ClientResponse> future = this.getFuture(resource, ClientResponse.class);
        return future.map(response -> response.getStatus() == Response.Status.OK.getStatusCode()).recover(ex -> {
            if (ex instanceof NotFoundException) {
                return false;
            }
            throw (RuntimeException)ex;
        });
    }

    private WebResource newContentRestrictionsWebResource(ContentId contentId) {
        Objects.requireNonNull(contentId, CONTENTID_CANNOT_BE_NULL);
        return this.newRestWebResource().path("content").path(contentId.serialise()).path("restriction");
    }

    private WebResource newContentRestrictionsExperimentalWebResource(ContentId contentId) {
        Objects.requireNonNull(contentId, CONTENTID_CANNOT_BE_NULL);
        return this.newExperimentalRestWebResource().path("content").path(contentId.serialise()).path("restriction");
    }
}

