/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.permissions.ContentRestrictionService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentRestrictionService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;

public class RemoteContentRestrictionServiceImpl
extends AbstractRemoteService<ContentRestrictionService>
implements RemoteContentRestrictionService {
    private static final String BY_OPERATION_SUBPATH = "byOperation";

    public RemoteContentRestrictionServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public Promise<Map<OperationKey, ContentRestriction>> getRestrictionsGroupByOperation(ContentId target, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.newContentRestrictionsWebResource(target).path(BY_OPERATION_SUBPATH);
        resource = this.addExpansions(resource, expansions);
        return this.getFutureMap(resource, OperationKey.class, ContentRestriction.class);
    }

    @Override
    public Promise<ContentRestriction> getRestrictionsForOperation(ContentId target, OperationKey operationKey, PageRequest pageRequest, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.newContentRestrictionsWebResource(target).path(BY_OPERATION_SUBPATH).path(operationKey.toString());
        resource = this.addExpansions(resource, expansions);
        resource = this.addPageRequest(resource, pageRequest);
        return this.getFuture(resource, ContentRestriction.class);
    }

    private WebResource newContentRestrictionsWebResource(ContentId contentId) {
        return this.newRestWebResource().path("content").path(contentId.serialise()).path("restriction");
    }
}

