/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ChildContentService;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteChildContentService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public class RemoteChildContentServiceImpl
extends AbstractRemoteService<ChildContentService>
implements RemoteChildContentService {
    public RemoteChildContentServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public RemoteChildContentService.RemoteChildContentFinder findContent(ContentId parentId, Expansion ... expansion) {
        return new RemoteChildContentFinderImpl(this, parentId, expansion);
    }

    public static class RemoteChildContentFinderImpl
    extends AbstractRemoteService<ChildContentService.ChildContentFinder>
    implements RemoteChildContentService.RemoteChildContentFinder {
        private WebResource resource;
        private Depth depth = Depth.ROOT;
        private int parentVersion = 0;
        private Collection<String> location;

        public RemoteChildContentFinderImpl(AbstractRemoteService other, ContentId parentId, Expansion[] expansion) {
            super(other);
            this.resource = this.newRestWebResource().path("content").path(parentId.serialise());
            this.resource = this.addExpansions(this.resource, expansion);
        }

        @Override
        public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByType(@Nullable PageRequest request) {
            this.resource = this.resource.path(this.getPathEndForDepth());
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams();
            return this.getFutureMapOfPageResponses(this.resource, ContentType.class, Content.class);
        }

        @Override
        public Promise<PageResponse<Content>> fetchMany(ContentType type, @Nullable PageRequest request) {
            this.resource = this.resource.path(this.getPathEndForDepth());
            this.resource = this.resource.path(type.getType().toLowerCase());
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams();
            return this.getFuturePageResponseList(this.resource, Content.class);
        }

        @Override
        public RemoteChildContentService.RemoteChildContentFinder withDepth(Depth depth) {
            this.depth = depth;
            return this;
        }

        @Override
        public RemoteChildContentService.RemoteChildContentFinder withParentVersion(int parentVersion) {
            this.parentVersion = parentVersion;
            return this;
        }

        @Override
        public RemoteChildContentService.RemoteChildContentFinder withLocation(Collection<String> location) {
            this.location = location;
            return this;
        }

        private String getPathEndForDepth() {
            if (this.depth == Depth.ROOT) {
                return "child";
            }
            if (this.depth == Depth.ALL) {
                return "descendant";
            }
            throw new NotImplementedServiceException("Only ROOT and ALL depth is currently supported");
        }

        private WebResource addParams() {
            if (this.location != null) {
                for (String locationValue : this.location) {
                    this.resource = this.resource.queryParam("location", locationValue);
                }
            }
            if (this.parentVersion != 0) {
                this.resource = this.resource.queryParam("parentVersion", String.valueOf(this.parentVersion));
            }
            return this.resource.queryParam("depth", this.depth.toString());
        }
    }
}

