/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.locator.ContentLocator;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import java.util.Map;
import org.joda.time.LocalDate;

@ExperimentalApi
public interface RemoteContentService {
    public RemoteContentFinder find(Expansion ... var1);

    public Promise<Content> create(Content var1);

    public Promise<Content> update(Content var1);

    public Promise<Content> trash(Content var1);

    public Promise<Content> restore(Content var1);

    public Promise<Void> purge(Content var1);

    public Promise<Void> delete(Content var1);

    public Promise<PageResponse<Content>> getChildren(Content var1, PageRequest var2, Expansion ... var3);

    public static interface RemoteContentFetcher
    extends RemoteSingleContentFetcher {
        public Promise<PageResponse<Content>> fetchMany(ContentType var1, PageRequest var2);

        public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByContentType(PageRequest var1);
    }

    public static interface RemoteSingleContentFetcher {
        public Promise<Option<Content>> fetchOne();

        public Promise<Content> fetchOneOrNull();
    }

    public static interface RemoteParameterContentFinder
    extends RemoteContentFetcher {
        public RemoteParameterContentFinder withSpace(Space ... var1);

        public RemoteParameterContentFinder withType(ContentType ... var1);

        public RemoteParameterContentFinder withCreatedDate(LocalDate var1);

        public RemoteParameterContentFinder withTitle(String var1);
    }

    public static interface RemoteContentFinder
    extends RemoteParameterContentFinder {
        public RemoteSingleContentFetcher withId(ContentId var1);

        public RemoteSingleContentFetcher withIdAndVersion(ContentId var1, int var2);

        public RemoteSingleContentFetcher withId(ContentId var1, ContentId ... var2);

        public RemoteSingleContentFetcher withId(Iterable<ContentId> var1);

        public RemoteSingleContentFetcher withLocator(ContentLocator var1);

        public RemoteContentFinder withStatus(ContentStatus ... var1);

        public RemoteContentFinder withAnyStatus();
    }
}

