package com.atlassian.confluence.rest.client;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.service.content.ContentBodyConversionService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.util.concurrent.Promise;

/**
 * {@link ContentBodyConversionService} implementation that communicates with Confluence remotely using the Confluence REST api.
 *
 * Provides future returning equivalents for the methods in ContentBodyConversionService.
 */
@ExperimentalApi
public interface RemoteContentBodyConversionService
{
    /**
     * Convert a ContentBody value into another format, performing validation during the conversion.
     *
     * @param body the content to convert
     * @param representation the {@link ContentRepresentation} to convert to
     * @return the converted body
     * @throws BadRequestException if any validation errors are found during the conversion
     */
    Promise<ContentBody> convert(ContentBody body, ContentRepresentation representation) throws BadRequestException;
}
