package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;

public class RemoteCQLSearchServiceImpl extends AbstractRemoteService<CQLSearchService> implements RemoteCQLSearchService
{
    public RemoteCQLSearchServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor)
    {
        super(provider, executor);
    }

    @Override
    public Promise<PageResponse<Content>> searchContent(String cql, PageRequest request, Expansion... expansions)
    {
        WebResource resource = getContentSearchWebResource();
        resource = addExpansions(resource, expansions);
        if (request != null)
            resource = addPageRequest(resource, request);

        resource = resource.queryParam("cql", cql);
        return getFuturePageResponseList(resource, Content.class);
    }

    @Override
    public Promise<PageResponse<Content>> searchContent(String cql, Expansion... expansions)
    {
        return searchContent(cql, null, expansions);
    }

    @Override
    public int countContent(String cql)
    {
        throw new NotImplementedServiceException("countContent not implemented by remoteService");
    }

    private WebResource getContentSearchWebResource()
    {
        //TODO update to /content when no longer experimental
        return newExperimentalRestWebResource().path("content");
    }
}
