package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.service.permissions.ContentRestrictionService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;

import java.util.Map;

public class RemoteContentRestrictionServiceImpl extends AbstractRemoteService<ContentRestrictionService> implements RemoteContentRestrictionService
{
    private static final String BY_OPERATION_SUBPATH = "byOperation"; // Used for resource path building.

    public RemoteContentRestrictionServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor)
    {
        super(provider, executor);
    }

    @Override
    public Promise<Map<OperationKey, ContentRestriction>> getRestrictionsGroupByOperation(ContentId target, Expansion... expansions)
    {

        WebResource resource = newContentRestrictionsWebResource(target).path(BY_OPERATION_SUBPATH);
        resource = addExpansions(resource, expansions);

        return getFutureMap(resource, OperationKey.class, ContentRestriction.class);
    }

    private WebResource newContentRestrictionsWebResource(ContentId contentId)
    {
        //TODO CRA-325: update to /content when no longer experimental
        return newExperimentalRestWebResource().path("content").path(contentId.serialise()).path("restriction");
    }
}
