package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.MacroInstance;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentMacroService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentMacroService;
import com.atlassian.confluence.rest.client.RemoteContentServiceImpl;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;

import javax.annotation.Nullable;

import static com.atlassian.confluence.api.service.content.ContentMacroService.MacroInstanceFinder;

public class RemoteContentMacroServiceImpl extends AbstractRemoteService<ContentMacroService> implements RemoteContentMacroService
{
    private RemoteContentServiceImpl contentService;

    public RemoteContentMacroServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor)
    {
        super(provider, executor);
        this.contentService = new RemoteContentServiceImpl(provider, executor);
    }

    @Override
    public RemoteMacroFinder findInContent(ContentId content, Expansion... expansions)
    {
        return new RemoteMacroFinderImpl(this, content);
    }

    public class RemoteMacroFinderImpl extends AbstractRemoteService<MacroInstanceFinder> implements RemoteMacroFinder
    {

        private final ContentId contentId;
        private String hash;
        private int versionNumber;

        protected RemoteMacroFinderImpl(AbstractRemoteService otherService, ContentId contentId)
        {
            super(otherService);
            this.contentId = contentId;
        }

        @Override
        public RemoteMacroFinder withHash(String hash)
        {
            this.hash = hash;
            return this;
        }

        @Override
        public RemoteMacroFinder withContentVersion(int versionNumber)
        {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public Promise<Option<MacroInstance>> fetchOne()
        {
            WebResource resource =  contentService.newContentWebResource()
                    .path(contentId.serialise())
                    .path("history")
                    .path(Integer.toString(versionNumber))
                    .path("macro")
                    .path("hash").path(hash);

            return getFutureOption(resource, MacroInstance.class);
        }

        @Override
        public Promise<MacroInstance> fetchOneOrNull()
        {
            return fetchOne().map(new Function<Option<MacroInstance>, MacroInstance>(){

                @Override
                public MacroInstance apply(@Nullable Option<MacroInstance> input)
                {
                    return input.getOrNull();
                }
            });
        }
    }
}
