package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.util.concurrent.Promise;

import java.util.Map;

/**
 * {@link com.atlassian.confluence.api.service.permissions.ContentRestrictionService} implementation that communicates with Confluence remotely using the Confluence REST API.
 *
 * Provides future returning equivalents for the methods in ContentRestrictionService.
 *
 * @since 5.7
 */
public interface RemoteContentRestrictionService
{
    Promise<Map<OperationKey, ContentRestriction>> getRestrictionsGroupByOperation(ContentId target, Expansion... expansions);
}
