package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.content.id.JsonContentPropertyId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;

/**
 * {@link com.atlassian.confluence.api.service.content.ContentPropertyService} implementation that communicates with
 * Confluence remotely using the Confluence REST API.
 *
 * @since 5.6
 */
public interface RemoteContentPropertyService
{
    RemoteContentPropertyFinder find(Expansion... expansions);

    RemoteValidator validator();

    /**
     * Create a content property.
     *
     * @param newProperty the content property to create
     * @return the content property created
     */
    Promise<JsonContentProperty> create(JsonContentProperty newProperty);

    /**
     * Updates a content property.
     *
     * @param property the updated {@link com.atlassian.confluence.api.model.content.JsonContentProperty} with metadata about the change
     * @return the updated content after being persisted
     */
    Promise<JsonContentProperty> update(JsonContentProperty property);

    /**
     * Removes a content property from the system.
     *
     * @param property the content property to remove
     */
    Promise<Void> delete(JsonContentProperty property);

    interface RemoteContentPropertyFinder extends RemoteParameterContentPropertyFinder
    {
        RemoteSingleContentPropertyFetcher withId(JsonContentPropertyId contentPropertyId);
    }

    interface RemoteParameterContentPropertyFinder extends RemoteContentPropertyFetcher
    {
        RemoteParameterContentPropertyFinder withContentId(ContentId contentId);

        RemoteParameterContentPropertyFinder withKey(String key);
    }

    interface RemoteSingleContentPropertyFetcher
    {
        Promise<Option<JsonContentProperty>> fetchOne();

        Promise<JsonContentProperty> fetchOneOrNull();
    }

    interface RemoteContentPropertyFetcher extends RemoteSingleContentPropertyFetcher
    {
        Promise<PageResponse<JsonContentProperty>> fetchMany(PageRequest request);
    }

    interface RemoteValidator
    {

    }
}
