package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ContentLabelService;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.api.model.RestList;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.StringKeyStringValueIgnoreCaseMultivaluedMap;

import java.util.Collection;
import java.util.List;

public class RemoteContentLabelServiceImpl extends AbstractRemoteService<ContentLabelService> implements RemoteContentLabelService
{

    public RemoteContentLabelServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor)
    {
        super(provider, executor);
    }

    @Override
    public Promise<PageResponse<Label>> getLabels(ContentId contentId, Collection<Label.Prefix> prefixes, PageRequest request) throws NotFoundException
    {
        List<String> prefixStrings = ImmutableList.copyOf(Iterables.transform(prefixes, Functions.toStringFunction()));

        WebResource resource = newRestWebResource().path("content").path(contentId.serialise()).path("label");
        StringKeyStringValueIgnoreCaseMultivaluedMap params = new StringKeyStringValueIgnoreCaseMultivaluedMap();
        params.put("prefix", prefixStrings);
        resource = resource.queryParams(params);
        resource = addPageRequestParams(resource, request);

        return getFuturePageResponseList(resource, Label.class);
    }

    @Override
    public Promise<PageResponse<Label>> addLabels(ContentId contentId, Iterable<Label> labels) throws ServiceException
    {
        WebResource resource = newRestWebResource().path("content").path(contentId.serialise()).path("label");
        return (Promise)postFuture(resource, RestList.class, Label.class, labels);
    }

    @Override
    public void removeLabels(ContentId contentId, Iterable<Label> labels) throws ServiceException
    {
        throw new UnsupportedOperationException("Remove labels not yet implemented");
    }

        /**
         * Remote validation is not currently supported, this method exists to satisfy the RemoteProxyCreator
         * @throws UnsupportedOperationException
         */
    public ContentLabelService.Validator validator()
    {
        throw new UnsupportedOperationException("Remote validation is not currently supported.");
    }
}