package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.service.content.ContentTrashService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.RemoteContentServiceImpl;
import com.atlassian.confluence.rest.client.RemoteContentTrashService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;

/**
 * {@link ContentTrashService} implementation that communicates with Confluence remotely.
 */

public class RemoteContentTrashServiceImpl extends AbstractRemoteService<ContentTrashService> implements RemoteContentTrashService
{
    private final RemoteContentService remoteContentService;

    public RemoteContentTrashServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor)
    {
        super(provider, executor);
        remoteContentService = new RemoteContentServiceImpl(provider, executor);
    }

    @Override
    public Promise<Void> trash(Content content)
    {
        WebResource resource = getContentTrashWebResource().path(content.getId().serialise());
        return deleteFuture(resource);
    }

    @Override
    public Promise<Content> restore(Content content)
    {
        // Restore is just a wrapper for update, where the input status is "current" and the existing status is
        // "trashed".
        return remoteContentService.update(content);
    }

    @Override
    public Promise<Void> purge(Content content)
    {
        WebResource resource = getContentTrashWebResource().path(content.getId().serialise()).queryParam("status", "trashed");
        return deleteFuture(resource);
    }

    private WebResource getContentTrashWebResource()
    {
        return newRestWebResource().path("content");
    }
}
