package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.api.model.longtasks.LongTaskStatus;
import com.atlassian.confluence.api.service.longtasks.LongTaskService;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;

/**
 * {@link LongTaskService} implementation that communicates with Confluence remotely using the Confluence REST API.
 *
 * Provides Promise-returning equivalents for the methods in LongTaskService.
 */
public interface RemoteLongTaskService
{
    /**
     * Returns the status of a long-running task.
     *
     * @param id the identifier of the task to return
     * @param expansions additional information about the
     * @return the long running task with the supplied id
     */
    Promise<Option<LongTaskStatus>> get(LongTaskId id, Expansion... expansions);
}
