package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.MacroInstance;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;

/**
 * A remote service to access macro instances on a piece of Content
 */
public interface RemoteContentMacroService
{
    /**
     * Retrieve details about a macro matching the page, version and macro hash.
     *
     * @param contentId The content to scan for the macro
     * @param expansions no expansions are currently supported
     *
     */
    RemoteMacroFinder findInContent(ContentId contentId, Expansion... expansions);

    interface RemoteMacroFinder
    {
        /**
         * @param hash The hash identifying the body of the macro
         * @return this
         */
        RemoteMacroFinder withHash(String hash);

        /**
         * @param versionNumber The version of the page to scan for the macro
         * @return this
         */
        RemoteMacroFinder withContentVersion(int versionNumber);

        /**
         * Fetch the macroinstance matching the with params from the remote server
         */
        Promise<Option<MacroInstance>> fetchOne();

        /**
         * Fetch the macroinstance matching the with params from the remote server
         */
        Promise<MacroInstance> fetchOneOrNull();
    }

}
